/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Tools {
    private static Logger log = Logger.getLogger(Tools.class);
    private static DecimalFormatSymbols ds = new DecimalFormatSymbols();
    private static DecimalFormat dfKurs;
    private static DecimalFormat dfKwota;
    private static DecimalFormat dfIlosc;
    private static DecimalFormat dfIloscNc;
    public static final String date_format = "yyyy-MM-dd";
    public static final String hour_format = "HH:mm";
    public static final String date_hour_format = "yyyy-MM-dd, HH:mm";
    public static final String waluta_format = "yy-MM-dd";

    public static String walidacjaTakNie(String in, String errorMsg) throws Exception {
        if (in == null) {
            return "Nie";
        }
        try {
            if (Tools.isTak(in)) {
                return "Tak";
            }
            return "Nie";
        }
        catch (NullPointerException e) {
            throw new Exception(errorMsg);
        }
    }

    public static int walidacjaInteger(Integer in, String errorMsg) throws Exception {
        if (in == null) {
            return 0;
        }
        return in;
    }

    public static double walidacjaDouble(String in, String errorMsg) throws Exception {
        if (in == null || in.trim().equalsIgnoreCase("")) {
            return 0.0;
        }
        try {
            return Tools.parseDouble(in);
        }
        catch (NullPointerException e) {
            throw new Exception(errorMsg);
        }
    }

    public static double walidacjaDouble(Double in, String errorMsg) throws Exception {
        if (in == null) {
            return 0.0;
        }
        return in;
    }

    public static boolean isTak(String in) {
        if (in == null || in.trim().equalsIgnoreCase("")) {
            return false;
        }
        return in.equalsIgnoreCase("tak");
    }

    public static String returnEmptyIfNull(Object str) {
        if (str == null) {
            return "";
        }
        return str.toString();
    }

    public static String formatKwota(Double liczba) {
        if (liczba == null) {
            return "";
        }
        return dfKwota.format(Tools.round2(liczba));
    }

    public static String formatKurs(Double liczba) {
        if (liczba == null) {
            return "";
        }
        return dfKurs.format(Tools.round4(liczba));
    }

    public static String formatIlosc(Double liczba) {
        if (liczba == null) {
            return "";
        }
        return dfIlosc.format(Math.round(liczba));
    }

    public static String formatIlosc(Integer liczba) {
        if (liczba == null) {
            return "";
        }
        return dfIlosc.format(liczba);
    }

    public static String formatIlosc(Long liczba) {
        if (liczba == null) {
            return "";
        }
        return dfIlosc.format(Math.round(liczba.longValue()));
    }

    public static String formatIloscNc(Long liczba) {
        if (liczba == null) {
            return "";
        }
        return dfIloscNc.format(Math.round(liczba.longValue()));
    }

    public static double round2(double liczba) {
        return (double)Math.round(liczba * 100.0) / 100.0;
    }

    public static double round4(Double liczba) {
        return (double)Math.round(liczba * 10000.0) / 10000.0;
    }

    public static Double wymnozenieKwotyiKursu(Double dAmount, Double dRate) {
        Long amount = Math.round(dAmount * 100.0);
        Long rate = Math.round(dRate * 10000.0);
        Long result = amount * rate;
        result = Math.round((double)result.longValue() / 10000.0);
        return (double)result.longValue() / 100.0;
    }

    public static String zmienMinutyNaGodziny(long minuty) {
        return Tools.formatKwota((double)minuty / 60.0);
    }

    public static String zmienMinutyNaDni(long minuty) {
        return Tools.formatKwota((double)minuty / 1440.0);
    }

    public static void logTraceContextMap(Map<String, Object> mapa, String msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)msg);
            mapa.forEach((key, value) -> log.trace((Object)(key + " = " + value)));
        }
    }

    public static String[] zmienDateNaString(Date data) {
        String[] data_czesci = new String[3];
        int rok = data.getYear() - 100;
        int miesiac = data.getMonth() + 1;
        int dzien = data.getDate();
        data_czesci[2] = dzien < 10 ? "0" + String.valueOf(dzien) : String.valueOf(dzien);
        data_czesci[1] = miesiac < 10 ? "0" + String.valueOf(miesiac) : String.valueOf(miesiac);
        data_czesci[0] = rok < 10 ? "0" + String.valueOf(rok) : String.valueOf(rok);
        return data_czesci;
    }

    public static String changeDateFormat(String date) {
        String formated_date = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(waluta_format);
            Date data_waluty = sdf.parse(date);
            sdf = new SimpleDateFormat(date_format);
            formated_date = sdf.format(data_waluty);
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return formated_date;
    }

    public static String getDateSubstring(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return "";
        }
        return dateString.length() > 10 ? dateString.substring(0, 10) : dateString;
    }

    public static Date zmienStringNaDate(String date) {
        String[] data_czesci = date.split("-");
        int year = Integer.parseInt(data_czesci[0]);
        if (year < 100) {
            year += 2000;
        }
        int month = Integer.parseInt(data_czesci[1]) - 1;
        int day = Integer.parseInt(data_czesci[2]);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        return cal.getTime();
    }

    public static Double parseDouble(String value) {
        return Double.parseDouble(value.replace(",", "."));
    }

    static {
        char DECIMAL_SEPARATOR_OF_SAVED_NUMBERS = '.';
        ds.setDecimalSeparator(DECIMAL_SEPARATOR_OF_SAVED_NUMBERS);
        dfKurs = new DecimalFormat("0.0000", ds);
        dfKwota = new DecimalFormat("0.00", ds);
        dfIlosc = new DecimalFormat("0", ds);
        dfIloscNc = new DecimalFormat("0.0", ds);
    }
}

