/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.automatictasks;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.plugin.categories.Categories;
import com.suncode.plugin.util.Tools;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

@Application
public class GenerateDocumentBaseOnDelegationModule {
    public static Logger log = Logger.getLogger(GenerateDocumentBaseOnDelegationModule.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("generate-pdf-base-on-delegation-app")).name("generate-pdf-base-on-delegation-app.name")).category(new Category[]{Categories.TOOLS})).icon((Icon)SilkIconPack.PAGE)).parameter().id("processid").name("generate-pdf-base-on-delegation-app-processid.name").description("generate-pdf-base-on-delegation-app-processid.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("activityid").name("generate-pdf-base-on-delegation-app-activityid.name").description("generate-pdf-base-on-delegation-app-activityid.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create();
    }

    public void execute(@Param String processid, @Param String activityid) throws Exception {
        try {
            log.debug((Object)"Start zadania automatycznego.");
            ProcessService processService = ServiceFactory.getProcessService();
            ActivityService activityService = ServiceFactory.getActivityService();
            ProcessDefinition processDefinition = processService.getProcessDefinition("proces_dele");
            DocumentTemplateService documentTemplateService = ServiceFactory.getDocumentTemplateService();
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentService documentService = ServiceFactory.getDocumentService();
            DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
            String processId = processid;
            String activityId = activityid;
            DocumentClass podsumowanieDelegacji = documentClassService.getDocumentClass("Podsumowania delegacji", new String[0]);
            DocumentTemplateTable rozliczenie = documentTemplateService.getByNameAndProcess("RozDel", processDefinition.getProcessDefinitionId(), new String[0]);
            if (rozliczenie != null) {
                Map pdfDataContent = activityService.getActivityContext(processId, activityId);
                pdfDataContent.put("wartosc_zaliczki", String.format("%.2f", pdfDataContent.get("wartosc_zaliczki")).replace(",", "."));
                Map<String, Object> baseDataToContent = this.getBaseDataToContent(pdfDataContent.get("identyfikator_wniosku").toString());
                Map<String, Object> routeDataToContent = this.getRouteDataToContent(pdfDataContent.get("identyfikator_wniosku").toString());
                Map<String, Object> quantitiesDataToContent = this.getQuantitiesDataToContent(pdfDataContent.get("identyfikator_wniosku").toString(), (Double)baseDataToContent.get("modul_kilometrowka"));
                Map<String, Object> spendingsDataToContent = this.getSpendingsDataToContent(processId, activityId);
                Map<String, Object> settlementDataToContent = this.getSettlementDataToContent(baseDataToContent, spendingsDataToContent, pdfDataContent, routeDataToContent);
                pdfDataContent.putAll(baseDataToContent);
                pdfDataContent.putAll(routeDataToContent);
                pdfDataContent.putAll(spendingsDataToContent);
                pdfDataContent.putAll(settlementDataToContent);
                pdfDataContent.putAll(quantitiesDataToContent);
                String akceptujacyDyrektorPionuLogin = pdfDataContent.get("akceptujacy_dyr_pi_dok").toString();
                UserFinder userFinder = FinderFactory.getUserFinder();
                User akceptujacyDyrektorPionuUser = userFinder.findByUserName(akceptujacyDyrektorPionuLogin, new String[0]);
                if (akceptujacyDyrektorPionuUser != null) {
                    pdfDataContent.put("akceptujacy_dyr_pi_dok_imie_nazwisko", akceptujacyDyrektorPionuUser.getFullName());
                } else {
                    pdfDataContent.put("akceptujacy_dyr_pi_dok_imie_nazwisko", "nie wymagana");
                }
                Double wartoscZaliczkiWPln = (Double)pdfDataContent.get("wartosc_zaliczki_w_pln");
                pdfDataContent.put("wartosc_zaliczki_w_pln_szablon", String.format("%.2f", wartoscZaliczkiWPln).replace(",", "."));
                Double kursZaliczki = (Double)pdfDataContent.get("kurs_zaliczki");
                pdfDataContent.put("kurs_zaliczki_szablon", String.format("%.4f", kursZaliczki).replace(",", "."));
                Double wartoscDokumentowZapl = (Double)pdfDataContent.get("wartosc_dokumentow_zapl");
                pdfDataContent.put("wartosc_dokumentow_zapl_szablon", String.format("%.2f", wartoscDokumentowZapl).replace(",", "."));
                double doZwrotuMinus = (Double)pdfDataContent.get("do_zwrotu");
                double doZwrotuPlus = (Double)pdfDataContent.get("do_zwrotu_plus");
                double doWyplaty = (Double)pdfDataContent.get("do_wyplaty");
                pdfDataContent.put("do_wyp\u0142aty_do_zwrotu_w_pln", "Do wyp\u0142aty/do zwrotu w PLN");
                pdfDataContent.put("wartosc_do_wyp\u0142aty_do_zwrotu_w_pln", String.format("%.2f", 0.0));
                if (doZwrotuMinus < 0.0) {
                    pdfDataContent.put("do_wyp\u0142aty_do_zwrotu_w_pln", "Do zwrotu w PLN");
                    pdfDataContent.put("wartosc_do_wyp\u0142aty_do_zwrotu_w_pln", String.format("%.2f", doZwrotuPlus));
                } else if (doWyplaty > 0.0) {
                    pdfDataContent.put("do_wyp\u0142aty_do_zwrotu_w_pln", "Do wyp\u0142aty w PLN");
                    pdfDataContent.put("wartosc_do_wyp\u0142aty_do_zwrotu_w_pln", String.format("%.2f", doWyplaty));
                }
                HashMap<String, String> indexes = new HashMap<String, String>();
                indexes.put("Nr delegacji", pdfDataContent.get("identyfikator_wniosku").toString());
                String templatePath = rozliczenie.getTemplatePath();
                String archiveDocumentClassName = podsumowanieDelegacji.getName();
                long fileId = PrepeareDoc.createPdfAndSaveInArchive((String)templatePath, (String)archiveDocumentClassName, (Map)pdfDataContent, (String)processId, (Map)pdfDataContent);
                WfDocument document = documentFinder.findByFileId(Long.valueOf(fileId), podsumowanieDelegacji.getId());
                IndexInfo indexNrDelegacji = document.getIndexByName("Nr delegacji");
                indexNrDelegacji.setValue((Object)pdfDataContent.get("identyfikator_wniosku").toString());
                documentService.updateDocument(document);
                List documents = documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
                for (WfDocument oneDocument : documents) {
                    if (!oneDocument.getDocumentClassId().equals(podsumowanieDelegacji.getId())) continue;
                    documentService.detachDocumentFromProcess(oneDocument.getId(), oneDocument.getDocumentClassId(), processId);
                    documentService.deleteDocument(oneDocument);
                    log.debug((Object)("Od\u0142\u0105czenie i usuni\u0119cie dokumentu - podsumowanie delegacji: " + oneDocument.getId()));
                }
                documentService.attachDocumentToProcess(document.getId(), podsumowanieDelegacji.getId(), "admin", processId, activityId);
            }
            DocumentClass kartyEwidencjiPojazdow = documentClassService.getDocumentClass("Karty ewidencji pojazd\u00f3w", new String[0]);
            DocumentTemplateTable szablonAuto = documentTemplateService.getByNameAndProcess("RozAuto", processDefinition.getProcessDefinitionId(), new String[0]);
            if (szablonAuto != null) {
                Map pdfDataContent = activityService.getActivityContext(processId, activityId);
                pdfDataContent.put("wartosc_zaliczki", String.format("%.2f", pdfDataContent.get("wartosc_zaliczki")).replace(",", "."));
                Map<String, Object> baseDataToContent = this.getBaseDataToContent(pdfDataContent.get("identyfikator_wniosku").toString());
                Map<String, Object> routeDataToContent = this.getRouteDataToContent(pdfDataContent.get("identyfikator_wniosku").toString());
                Map<String, Object> quantitiesDataToContent = this.getQuantitiesDataToContent(pdfDataContent.get("identyfikator_wniosku").toString(), (Double)baseDataToContent.get("modul_kilometrowka"));
                Map<String, Object> spendingsDataToContent = this.getSpendingsDataToContent(processId, activityId);
                Map<String, Object> settlementDataToContent = this.getSettlementDataToContent(baseDataToContent, spendingsDataToContent, pdfDataContent, routeDataToContent);
                pdfDataContent.putAll(baseDataToContent);
                pdfDataContent.putAll(routeDataToContent);
                pdfDataContent.putAll(spendingsDataToContent);
                pdfDataContent.putAll(settlementDataToContent);
                pdfDataContent.putAll(quantitiesDataToContent);
                String templatePath = szablonAuto.getTemplatePath();
                String archiveDocumentClassName = kartyEwidencjiPojazdow.getName();
                long fileId = PrepeareDoc.createPdfAndSaveInArchive((String)templatePath, (String)archiveDocumentClassName, (Map)pdfDataContent, (String)processId, (Map)pdfDataContent);
                WfDocument document = documentFinder.findByFileId(Long.valueOf(fileId), kartyEwidencjiPojazdow.getId());
                IndexInfo indexNrDelegacji = document.getIndexByName("Nr delegacji");
                indexNrDelegacji.setValue((Object)pdfDataContent.get("identyfikator_wniosku").toString());
                documentService.updateDocument(document);
                List documents = documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
                for (WfDocument oneDocument : documents) {
                    if (!oneDocument.getDocumentClassId().equals(kartyEwidencjiPojazdow.getId())) continue;
                    documentService.detachDocumentFromProcess(oneDocument.getId(), oneDocument.getDocumentClassId(), processId);
                    documentService.deleteDocument(oneDocument);
                    log.debug((Object)("Od\u0142\u0105czenie i usuni\u0119cie dokumentu - karta ewidencji pojazd\u00f3w: " + oneDocument.getId()));
                }
                documentService.attachDocumentToProcess(document.getId(), kartyEwidencjiPojazdow.getId(), "admin", processId, activityId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Object> getBaseDataToContent(String nrDelegacji) {
        String query = "SELECT nr_delegacji as modul_nr_delegacji, adres_uzytkownika_pojazdu as modul_adres_uzytkownika_pojazdu, cel_delegacji as modul_cel_delegacji, data_odjazdu as modul_data_odjazdu, data_powrotu as modul_data_powrotu, data_wydania_zaliczki as modul_data_wydania_zaliczki, daty_zgodne_z_wnioskiem as modul_daty_zgodne_z_wnioskiem, dieta_kraj as modul_dieta_kraj, dieta_zagranica as modul_dieta_zagranica, godziny_w_delegacji as modul_godziny_w_delegacji, imie_nazwisko as modul_imie_nazwisko, kilometrowka as modul_kilometrowka, koszty_paliwa as modul_koszty_paliwa, kraje_docelowe as modul_kraje_docelowe, marka_pojazdu as modul_marka_pojazdu, miasto_docelowe as modul_miasto_docelowe, minuty_w_delegacji as modul_minuty_w_delegacji, nr_rejestracyjny as modul_nr_rejestracyjny, pojemnosc_silnika as modul_pojemnosc_silnika, ryczalt_noclegi_kraj as modul_ryczalt_noclegi_kraj, ryczalt_noclegi_zagranica as modul_ryczalt_noclegi_zagranica, ryczalt_srodki_miejskie_kraj as modul_ryczalt_srodki_miejskie_kraj, ryczalt_srodki_miejskie_zagranica as modul_ryczalt_srodki_miejskie_zagranica, ryczalt_za_przejazdy_do_z_dworca as modul_ryczalt_za_przejazdy_do_z_dworca, sr_lokomocji as modul_sr_lokomocji, srodek_transportu as modul_srodek_transportu, stawka_za_1_km as modul_stawka_za_1_km, suma_wydatki as modul_suma_wydatki, typ_delegacji as modul_typ_delegacji, uwagi as modul_uwagi FROM roz_del WHERE nr_delegacji=:wartosc";
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery(query);
        builder.addScalar("modul_nr_delegacji", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_adres_uzytkownika_pojazdu", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_cel_delegacji", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_data_odjazdu", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_data_powrotu", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_data_wydania_zaliczki", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_daty_zgodne_z_wnioskiem", (Type)StandardBasicTypes.BOOLEAN);
        builder.addScalar("modul_dieta_kraj", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_dieta_zagranica", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_godziny_w_delegacji", (Type)StandardBasicTypes.INTEGER);
        builder.addScalar("modul_imie_nazwisko", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_kilometrowka", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_koszty_paliwa", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_kraje_docelowe", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_marka_pojazdu", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_miasto_docelowe", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_minuty_w_delegacji", (Type)StandardBasicTypes.BIG_INTEGER);
        builder.addScalar("modul_nr_rejestracyjny", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_pojemnosc_silnika", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_ryczalt_noclegi_kraj", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_ryczalt_noclegi_zagranica", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_ryczalt_srodki_miejskie_kraj", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_ryczalt_srodki_miejskie_zagranica", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_ryczalt_za_przejazdy_do_z_dworca", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_sr_lokomocji", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_srodek_transportu", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_stawka_za_1_km", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_suma_wydatki", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_typ_delegacji", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_uwagi", (Type)StandardBasicTypes.STRING);
        builder.setParameter("wartosc", (Object)nrDelegacji);
        SQLFinder finder = FinderFactory.getSQLFinder();
        List data = finder.find(builder);
        Map<String, String> dataToSend = new HashMap();
        dataToSend = (Map)data.get(0);
        dataToSend.put("daty_zgodne_z_wnioskiem", (Boolean)dataToSend.get("modul_daty_zgodne_z_wnioskiem") != false ? "zgodne z wnioskiem" : "niezgodne z wnioskiem");
        return (Map)data.get(0);
    }

    private Map<String, Object> getRouteDataToContent(String nrDelegacji) {
        String query = "SELECT id as modul_tab_id, data_przekroczenia_granicy as modul_tab_data_przekroczenia_granicy, godzina_przekroczenia_granicy as modul_tab_godzina_przekroczenia_granicy, km as modul_tab_km, lp as modul_tab_lp, przyjazd_data as modul_tab_przyjazd_data, przyjazd_godzina as modul_tab_przyjazd_godzina, przyjazd_kraj as modul_tab_przyjazd_kraj, przyjazd_miejscowosc as modul_tab_przyjazd_miejscowosc, srodek_transportu as modul_tab_srodek_transportu, wyjazd_data as modul_tab_wyjazd_data, wyjazd_godzina as modul_tab_wyjazd_godzina, wyjazd_kraj as modul_tab_wyjazd_kraj, wyjazd_miejscowosc as modul_tab_wyjazd_miejscowosc, nr_delegacji as modul_tab_nr_delegacji FROM roz_del_trasa WHERE nr_delegacji=:wartosc ORDER BY lp ";
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery(query);
        builder.addScalar("modul_tab_id", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_data_przekroczenia_granicy", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_godzina_przekroczenia_granicy", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_km", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_lp", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_przyjazd_data", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_przyjazd_godzina", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_przyjazd_kraj", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_przyjazd_miejscowosc", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_srodek_transportu", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_wyjazd_data", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_wyjazd_godzina", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_wyjazd_kraj", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_wyjazd_miejscowosc", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_nr_delegacji", (Type)StandardBasicTypes.STRING);
        builder.setParameter("wartosc", (Object)nrDelegacji);
        SQLFinder finder = FinderFactory.getSQLFinder();
        List data = finder.find(builder);
        HashMap<String, Object> dataToSend = new HashMap<String, Object>();
        StringBuilder id = new StringBuilder();
        StringBuilder data_przekroczenia_granicy = new StringBuilder();
        StringBuilder godzina_przekroczenia_granicy = new StringBuilder();
        StringBuilder km = new StringBuilder();
        StringBuilder lp = new StringBuilder();
        StringBuilder przyjazd_data = new StringBuilder();
        StringBuilder przyjazd_godzina = new StringBuilder();
        StringBuilder przyjazd_kraj = new StringBuilder();
        StringBuilder przyjazd_miejscowosc = new StringBuilder();
        StringBuilder srodek_transportu = new StringBuilder();
        StringBuilder wyjazd_data = new StringBuilder();
        StringBuilder wyjazd_godzina = new StringBuilder();
        StringBuilder wyjazd_kraj = new StringBuilder();
        StringBuilder wyjazd_miejscowosc = new StringBuilder();
        StringBuilder nr_delegacji = new StringBuilder();
        String separator = "";
        for (Map oneData : data) {
            id.append(separator).append(oneData.get("modul_tab_id"));
            data_przekroczenia_granicy.append(separator).append((Object)(oneData.get("modul_tab_data_przekroczenia_granicy") == null ? "" : oneData.get("modul_tab_data_przekroczenia_granicy")));
            godzina_przekroczenia_granicy.append(separator).append(oneData.get("modul_tab_godzina_przekroczenia_granicy"));
            km.append(separator).append(oneData.get("modul_tab_km"));
            lp.append(separator).append(oneData.get("modul_tab_lp"));
            przyjazd_data.append(separator).append(oneData.get("modul_tab_przyjazd_data"));
            przyjazd_godzina.append(separator).append(oneData.get("modul_tab_przyjazd_godzina"));
            przyjazd_kraj.append(separator).append(oneData.get("modul_tab_przyjazd_kraj"));
            przyjazd_miejscowosc.append(separator).append(oneData.get("modul_tab_przyjazd_miejscowosc"));
            srodek_transportu.append(separator).append(oneData.get("modul_tab_srodek_transportu"));
            wyjazd_data.append(separator).append(oneData.get("modul_tab_wyjazd_data"));
            wyjazd_godzina.append(separator).append(oneData.get("modul_tab_wyjazd_godzina"));
            wyjazd_kraj.append(separator).append(oneData.get("modul_tab_wyjazd_kraj"));
            wyjazd_miejscowosc.append(separator).append(oneData.get("modul_tab_wyjazd_miejscowosc"));
            nr_delegacji.append(separator).append(oneData.get("modul_tab_nr_delegacji"));
            separator = ";";
        }
        dataToSend.put("modul_tab_id", id.toString());
        dataToSend.put("modul_tab_przekroczenie_granicy_data", data_przekroczenia_granicy.toString());
        dataToSend.put("modul_tab_przekroczenie_granicy_godzina", godzina_przekroczenia_granicy.toString());
        dataToSend.put("modul_tab_km", km.toString());
        dataToSend.put("modul_tab_lp", lp.toString());
        dataToSend.put("modul_tab_przyjazd_data", przyjazd_data.toString());
        dataToSend.put("modul_tab_przyjazd_godzina", przyjazd_godzina.toString());
        dataToSend.put("modul_tab_przyjazd_kraj", przyjazd_kraj.toString());
        dataToSend.put("modul_tab_przyjazd_miejscowosc", przyjazd_miejscowosc.toString());
        dataToSend.put("modul_tab_srodek_transportu", srodek_transportu.toString());
        dataToSend.put("modul_tab_wyjazd_data", wyjazd_data.toString());
        dataToSend.put("modul_tab_wyjazd_godzina", wyjazd_godzina.toString());
        dataToSend.put("modul_tab_wyjazd_kraj", wyjazd_kraj.toString());
        dataToSend.put("modul_tab_wyjazd_miejscowosc", wyjazd_miejscowosc.toString());
        dataToSend.put("modul_tab_nr_delegacji", nr_delegacji.toString());
        return dataToSend;
    }

    private Map<String, Object> getQuantitiesDataToContent(String nrDelegacji, Double kilometrowka) {
        String query = "SELECT id as modul_tab_ilosci_id, calodobowe_wyzywienie as modul_tab_ilosci_calodobowe_wyzywienie, data_kursu as modul_tab_ilosci_data_kursu, COALESCE(dieta_w_walucie_kraju, 0.0) as modul_tab_ilosci_dieta_w_walucie_kraju, COALESCE(dieta_w_walucie_kraju_bez_rycz, 0.0) as modul_tab_ilosci_dieta_w_walucie_kraju_bez_rycz, COALESCE(ilosc_diet, 0.0) as modul_tab_ilosci_ilosc_diet, COALESCE(ilosc_diet_bez_rycz, 0.0) as modul_tab_ilosci_ilosc_diet_bez_rycz, kraj as modul_tab_ilosci_kraj, COALESCE(kurs_walutowy, 0.0) as modul_tab_ilosci_kurs_walutowy, COALESCE(minuty_w_delegacji, 0) as modul_tab_ilosci_minuty_w_delegacji, COALESCE(niezapewnione_doby_komunikacji_miejskiej, 0) as modul_tab_ilosci_niezapewnione_doby_komunikacji_miejskiej, COALESCE(niezapewnione_noclegi, 0) as modul_tab_ilosci_niezapewnione_noclegi, COALESCE(niezapewnione_przejazdy_do_z_dworca, 0.0) as modul_tab_ilosci_niezapewnione_przejazdy_do_z_dworca, COALESCE(ryczalt_doby_kom_miejskiej, 0.0) as modul_tab_ilosci_ryczalt_doby_kom_miejskiej, COALESCE(ryczalt_noclegi, 0.0) as modul_tab_ilosci_ryczalt_noclegi, COALESCE(ryczalt_przejazdy_do_z_dworca, 0.0) as modul_tab_ilosci_ryczalt_przejazdy_do_z_dworca, COALESCE(stawka_diety, 0.0) as modul_tab_ilosci_stawka_diety, waluta as modul_tab_ilosci_waluta, COALESCE(zapewnione_kolacje, 0) as modul_tab_ilosci_zapewnione_kolacje, COALESCE(zapewnione_obiady, 0) as modul_tab_ilosci_zapewnione_obiady, COALESCE(zapewnione_sniadania, 0) as modul_tab_ilosci_zapewnione_sniadania, nr_delegacji as modul_tab_ilosci_nr_delegacji, COALESCE(dieta_pelna_w_walucie, 0.0) as modul_tab_ilosci_dieta_pelna_w_walucie, COALESCE(dieta_potracenia_w_walucie, 0.0) as modul_tab_ilosci_dieta_potracenia_w_walucie FROM roz_del_ilosci WHERE nr_delegacji=:wartosc ORDER BY id";
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery(query);
        builder.addScalar("modul_tab_ilosci_id", (Type)StandardBasicTypes.BIG_INTEGER);
        builder.addScalar("modul_tab_ilosci_calodobowe_wyzywienie", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_ilosci_data_kursu", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_ilosci_dieta_w_walucie_kraju", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_dieta_w_walucie_kraju_bez_rycz", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_ilosc_diet", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_ilosc_diet_bez_rycz", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_kraj", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_ilosci_kurs_walutowy", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_minuty_w_delegacji", (Type)StandardBasicTypes.BIG_INTEGER);
        builder.addScalar("modul_tab_ilosci_niezapewnione_doby_komunikacji_miejskiej", (Type)StandardBasicTypes.INTEGER);
        builder.addScalar("modul_tab_ilosci_niezapewnione_noclegi", (Type)StandardBasicTypes.INTEGER);
        builder.addScalar("modul_tab_ilosci_niezapewnione_przejazdy_do_z_dworca", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_ryczalt_doby_kom_miejskiej", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_ryczalt_noclegi", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_ryczalt_przejazdy_do_z_dworca", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_stawka_diety", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_waluta", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_ilosci_zapewnione_kolacje", (Type)StandardBasicTypes.INTEGER);
        builder.addScalar("modul_tab_ilosci_zapewnione_obiady", (Type)StandardBasicTypes.INTEGER);
        builder.addScalar("modul_tab_ilosci_zapewnione_sniadania", (Type)StandardBasicTypes.INTEGER);
        builder.addScalar("modul_tab_ilosci_nr_delegacji", (Type)StandardBasicTypes.STRING);
        builder.addScalar("modul_tab_ilosci_dieta_pelna_w_walucie", (Type)StandardBasicTypes.DOUBLE);
        builder.addScalar("modul_tab_ilosci_dieta_potracenia_w_walucie", (Type)StandardBasicTypes.DOUBLE);
        builder.setParameter("wartosc", (Object)nrDelegacji);
        SQLFinder finder = FinderFactory.getSQLFinder();
        List data = finder.find(builder);
        Double del_sum = 0.0;
        StringBuilder kraj = new StringBuilder();
        StringBuilder niezapewnione_doby_komunikacji_miejskiej = new StringBuilder();
        StringBuilder niezapewnione_noclegi = new StringBuilder();
        StringBuilder zapewnione_sniadania = new StringBuilder();
        StringBuilder zapewnione_obiady = new StringBuilder();
        StringBuilder zapewnione_kolacje = new StringBuilder();
        StringBuilder niezapewnione_przejazdy_do_z_dworca = new StringBuilder();
        StringBuilder dieta_w_walucie_kraju = new StringBuilder();
        StringBuilder tab_wartosc_del_w_pln = new StringBuilder();
        StringBuilder waluta = new StringBuilder();
        StringBuilder kurs_walutowy = new StringBuilder();
        StringBuilder data_kursu = new StringBuilder();
        StringBuilder godziny_w_delegacji = new StringBuilder();
        StringBuilder tab_ryczalt_za_niezapewnione = new StringBuilder();
        StringBuilder tab_zapewnione_cal_dz = new StringBuilder();
        StringBuilder tab_dni_w_delegacji = new StringBuilder();
        StringBuilder tab_stawka_diety = new StringBuilder();
        StringBuilder tab_ryczalt_sam_pryw = new StringBuilder();
        StringBuilder dieta_w_walucie_kraju_bez_rycz = new StringBuilder();
        StringBuilder ilosci_diet = new StringBuilder();
        StringBuilder tripFullReward = new StringBuilder();
        StringBuilder tripRewardDeductions = new StringBuilder();
        StringBuilder countryTotal = new StringBuilder();
        StringBuilder countryTotalPln = new StringBuilder();
        String separator = "";
        for (Map row : data) {
            if (row == null || row.get("modul_tab_ilosci_kraj") == null || row.get("modul_tab_ilosci_kraj").equals("")) continue;
            if (separator.length() > 0) {
                kraj.append(";");
                niezapewnione_doby_komunikacji_miejskiej.append(";");
                niezapewnione_noclegi.append(";");
                zapewnione_sniadania.append(";");
                zapewnione_obiady.append(";");
                zapewnione_kolacje.append(";");
                niezapewnione_przejazdy_do_z_dworca.append(";");
                dieta_w_walucie_kraju.append(";");
                tab_wartosc_del_w_pln.append(";");
                waluta.append(";");
                kurs_walutowy.append(";");
                data_kursu.append(";");
                godziny_w_delegacji.append(";");
                tab_zapewnione_cal_dz.append(";");
                tab_ryczalt_za_niezapewnione.append(";");
                tab_dni_w_delegacji.append(";");
                tab_stawka_diety.append(";");
                tab_ryczalt_sam_pryw.append(";");
                dieta_w_walucie_kraju_bez_rycz.append(";");
                ilosci_diet.append(";");
                tripFullReward.append(";");
                tripRewardDeductions.append(";");
                countryTotal.append(";");
                countryTotalPln.append(";");
            }
            kraj.append(row.get("modul_tab_ilosci_kraj"));
            niezapewnione_doby_komunikacji_miejskiej.append(Tools.formatIlosc((Integer)row.get("modul_tab_ilosci_niezapewnione_doby_komunikacji_miejskiej")));
            niezapewnione_noclegi.append(Tools.formatIlosc((Integer)row.get("modul_tab_ilosci_niezapewnione_noclegi")));
            zapewnione_sniadania.append(Tools.formatIlosc((Integer)row.get("modul_tab_ilosci_zapewnione_sniadania")));
            zapewnione_obiady.append(Tools.formatIlosc((Integer)row.get("modul_tab_ilosci_zapewnione_obiady")));
            zapewnione_kolacje.append(Tools.formatIlosc((Integer)row.get("modul_tab_ilosci_zapewnione_kolacje")));
            niezapewnione_przejazdy_do_z_dworca.append(Tools.formatIlosc((Double)row.get("modul_tab_ilosci_niezapewnione_przejazdy_do_z_dworca")));
            dieta_w_walucie_kraju.append(Tools.formatKwota((Double)row.get("modul_tab_ilosci_dieta_w_walucie_kraju")));
            dieta_w_walucie_kraju_bez_rycz.append(Tools.formatKwota((Double)row.get("modul_tab_ilosci_dieta_w_walucie_kraju_bez_rycz")));
            waluta.append(Tools.returnEmptyIfNull(row.get("modul_tab_ilosci_waluta")));
            if (!row.get("modul_tab_ilosci_kraj").toString().equalsIgnoreCase("Polska")) {
                kurs_walutowy.append(Tools.formatKurs((Double)row.get("modul_tab_ilosci_kurs_walutowy")));
                data_kursu.append(Tools.changeDateFormat(row.get("modul_tab_ilosci_data_kursu").toString()));
                Double dieta_w_pln = Tools.wymnozenieKwotyiKursu((Double)row.get("modul_tab_ilosci_dieta_w_walucie_kraju"), (Double)row.get("modul_tab_ilosci_kurs_walutowy"));
                del_sum = del_sum + dieta_w_pln;
                tab_wartosc_del_w_pln.append(Tools.formatKwota(dieta_w_pln));
            } else {
                tab_ryczalt_sam_pryw.append(Tools.formatKwota(kilometrowka));
                del_sum = del_sum + (Double)row.get("modul_tab_ilosci_dieta_w_walucie_kraju");
                tab_wartosc_del_w_pln.append(Tools.formatKwota((Double)row.get("modul_tab_ilosci_dieta_w_walucie_kraju")));
            }
            godziny_w_delegacji.append(Tools.zmienMinutyNaGodziny(((BigInteger)row.get("modul_tab_ilosci_minuty_w_delegacji")).longValue()));
            long ryczalt_za_niezapewnione = 0L;
            if (row.get("modul_tab_ilosci_ryczalt_doby_kom_miejskiej") != null) {
                ryczalt_za_niezapewnione += Math.round((Double)row.get("modul_tab_ilosci_ryczalt_doby_kom_miejskiej") * 100.0);
            }
            if (row.get("modul_tab_ilosci_ryczalt_noclegi") != null) {
                ryczalt_za_niezapewnione += Math.round((Double)row.get("modul_tab_ilosci_ryczalt_noclegi") * 100.0);
            }
            if (row.get("modul_tab_ilosci_ryczalt_przejazdy_do_z_dworca") != null) {
                ryczalt_za_niezapewnione += Math.round((Double)row.get("modul_tab_ilosci_ryczalt_przejazdy_do_z_dworca") * 100.0);
            }
            tab_ryczalt_za_niezapewnione.append(Tools.formatKwota((double)ryczalt_za_niezapewnione / 100.0));
            if (row.get("modul_tab_ilosci_calodobowe_wyzywienie") != null) {
                tab_zapewnione_cal_dz.append(Tools.isTak(row.get("modul_tab_ilosci_calodobowe_wyzywienie").toString()) ? "X" : "");
            }
            tab_dni_w_delegacji.append(Tools.zmienMinutyNaDni(((BigInteger)row.get("modul_tab_ilosci_minuty_w_delegacji")).longValue()));
            tab_stawka_diety.append(row.get("modul_tab_ilosci_stawka_diety"));
            ilosci_diet.append(Tools.formatKwota((Double)row.get("modul_tab_ilosci_ilosc_diet")));
            tripFullReward.append(Tools.formatKwota((Double)row.get("modul_tab_ilosci_dieta_pelna_w_walucie")));
            tripRewardDeductions.append(Tools.formatKwota((Double)row.get("modul_tab_ilosci_dieta_potracenia_w_walucie")));
            Double carKmReward = row.get("modul_tab_ilosci_kraj").toString().equalsIgnoreCase("Polska") ? kilometrowka : 0.0;
            Double total = (Double)row.get("modul_tab_ilosci_dieta_w_walucie_kraju") + (double)ryczalt_za_niezapewnione / 100.0 + carKmReward;
            countryTotal.append(Tools.formatKwota(total));
            Double exchange = row.get("modul_tab_ilosci_kraj").toString().equalsIgnoreCase("Polska") ? 1.0 : (Double)row.get("modul_tab_ilosci_kurs_walutowy");
            Double totalPln = Tools.wymnozenieKwotyiKursu(total, exchange);
            countryTotalPln.append(Tools.formatKwota(totalPln));
            separator = ";";
        }
        HashMap<String, Object> dataToSend = new HashMap<String, Object>();
        dataToSend.put("modul_tab_ilosci_kraj", kraj.toString());
        dataToSend.put("modul_tab_ilosci_niezapewnione_doby_komunikacji_miejskiej", niezapewnione_doby_komunikacji_miejskiej.toString());
        dataToSend.put("modul_tab_ilosci_niezapewnione_noclegi", niezapewnione_noclegi.toString());
        dataToSend.put("modul_tab_ilosci_zapewnione_sniadania", zapewnione_sniadania.toString());
        dataToSend.put("modul_tab_ilosci_zapewnione_obiady", zapewnione_obiady.toString());
        dataToSend.put("modul_tab_ilosci_zapewnione_kolacje", zapewnione_kolacje.toString());
        dataToSend.put("modul_tab_ilosci_niezapewnione_przejazdy_do_z_dworca", niezapewnione_przejazdy_do_z_dworca.toString());
        dataToSend.put("modul_tab_ilosci_dieta_w_walucie_kraju", dieta_w_walucie_kraju_bez_rycz.toString());
        dataToSend.put("modul_tab_ilosci_wartosc_del_w_wal", dieta_w_walucie_kraju.toString());
        dataToSend.put("modul_tab_ilosci_wartosc_del_w_pln", tab_wartosc_del_w_pln.toString());
        dataToSend.put("modul_tab_ilosci_waluta", waluta.toString());
        dataToSend.put("modul_tab_ilosci_kurs_walutowy", kurs_walutowy.toString());
        dataToSend.put("modul_tab_ilosci_data_kursu", data_kursu.toString());
        dataToSend.put("modul_tab_ilosci_godziny_w_delegacji", godziny_w_delegacji.toString());
        dataToSend.put("modul_tab_ilosci_ryczalt_za_niezapewnione", tab_ryczalt_za_niezapewnione.toString());
        dataToSend.put("modul_tab_ilosci_zapewnione_cal_dz", tab_zapewnione_cal_dz.toString());
        dataToSend.put("modul_tab_ilosci_dni_w_delegacji", tab_dni_w_delegacji.toString());
        dataToSend.put("modul_tab_ilosci_stawka_diety", tab_stawka_diety.toString());
        dataToSend.put("modul_tab_ilosci_ryczalt_sam_pryw", tab_ryczalt_sam_pryw.toString());
        dataToSend.put("modul_tab_ilosci_ilosci_diet", ilosci_diet);
        dataToSend.put("modul_tab_ilosci_dieta_pelna", tripFullReward.toString());
        dataToSend.put("modul_tab_ilosci_dieta_potracenia", tripRewardDeductions.toString());
        dataToSend.put("modul_tab_ilosci_suma_kraj", countryTotal.toString());
        dataToSend.put("modul_tab_ilosci_suma_kraj_pln", countryTotalPln.toString());
        dataToSend.put("del_sum", Tools.formatKwota(del_sum));
        return dataToSend;
    }

    private Map<String, Object> getSpendingsDataToContent(String processId, String activityId) {
        ActivityService activityService = ServiceFactory.getActivityService();
        Map activityContext = activityService.getActivityContext(processId, activityId);
        StringBuilder spendingType = new StringBuilder();
        StringBuilder spendingName = new StringBuilder();
        StringBuilder spendingPlnAmount = new StringBuilder();
        StringBuilder spendingAmount = new StringBuilder();
        StringBuilder spendingCurrency = new StringBuilder();
        StringBuilder spendingExchangeRate = new StringBuilder();
        StringBuilder spendingDate = new StringBuilder();
        StringBuilder spendingPaymentMethod = new StringBuilder();
        StringBuilder spendingDocumentType = new StringBuilder();
        String separator = "";
        String kontoKsiegowe = activityContext.get("konto_ksiegowe").toString();
        String[] kontoKsiegoweSplitted = kontoKsiegowe.split(";", -1);
        String opisLinii = activityContext.get("opis_linii").toString();
        String[] opisLiniiSplitted = opisLinii.split(";", -1);
        for (int i = 0; i < kontoKsiegoweSplitted.length; ++i) {
            if (kontoKsiegoweSplitted[i].compareTo("62100") == 0 || kontoKsiegoweSplitted[i].compareTo("62101") == 0 || kontoKsiegoweSplitted[i].compareTo("62000") == 0 && (kontoKsiegoweSplitted[i].compareTo("62000") != 0 || opisLiniiSplitted[i].toLowerCase().contains("rycza\u0142t"))) continue;
            spendingType.append(separator).append(activityContext.get("rodzaj_kosztu").toString().split(";", -1)[i]);
            spendingName.append(separator).append(activityContext.get("opis_linii").toString().split(";", -1)[i]);
            spendingAmount.append(separator).append(activityContext.get("kwota_brutto_w_walucie").toString().split(";", -1)[i]);
            spendingCurrency.append(separator).append(activityContext.get("waluta_kosztu").toString().split(";", -1)[i]);
            spendingDate.append(separator).append(activityContext.get("data_wystawienia_dokume").toString().split(";", -1)[i]);
            spendingExchangeRate.append(separator).append(activityContext.get("kurs_rozliczenia").toString().split(";", -1)[i]);
            spendingPlnAmount.append(separator).append(activityContext.get("kwota_brutto_w_pln").toString().split(";", -1)[i]);
            spendingPaymentMethod.append(separator).append(activityContext.get("forma_platnosci").toString().split(";", -1)[i]);
            spendingDocumentType.append(separator).append(activityContext.get("typ_dokumentu").toString().split(";", -1)[i]);
            separator = ";";
        }
        HashMap<String, Object> dataToSend = new HashMap<String, Object>();
        dataToSend.put("tab_wydatki_rodzaj_wydatku", spendingType);
        dataToSend.put("tab_wydatki_nazwa_wydatku", spendingName);
        dataToSend.put("tab_wydatki_kwota_wydatku_pln", spendingPlnAmount);
        dataToSend.put("tab_wydatki_kwota_wydatku", spendingAmount);
        dataToSend.put("tab_wydatki_waluta_wydatku", spendingCurrency);
        dataToSend.put("tab_wydatki_kurs_waluty_wydatku", spendingExchangeRate);
        dataToSend.put("tab_wydatki_data_wydatku", spendingDate);
        dataToSend.put("tab_wydatki_forma_platnosci_wydatku", spendingPaymentMethod);
        dataToSend.put("tab_wydatki_typ_dokumentu_wydatku", spendingDocumentType);
        return dataToSend;
    }

    private Map<String, Object> getSettlementDataToContent(Map<String, Object> delegacja, Map<String, Object> spendingsDataToContent, Map<String, Object> pdfDataContent, Map<String, Object> routeDataToContent) {
        String[] kosztPlnSplitted;
        Double totalTripReward = (Double)delegacja.get("modul_dieta_kraj") + (Double)delegacja.get("modul_ryczalt_srodki_miejskie_kraj") + (Double)delegacja.get("modul_ryczalt_noclegi_kraj");
        if (!delegacja.get("modul_typ_delegacji").toString().equalsIgnoreCase("kraj")) {
            totalTripReward = totalTripReward + ((Double)delegacja.get("modul_dieta_zagranica") + (Double)delegacja.get("modul_ryczalt_srodki_miejskie_zagranica") + (Double)delegacja.get("modul_ryczalt_noclegi_zagranica") + (Double)delegacja.get("modul_ryczalt_za_przejazdy_do_z_dworca"));
        }
        totalTripReward = totalTripReward + (Double)delegacja.get("modul_kilometrowka");
        Double totalPlnSpendings = 0.0;
        String kosztPln = spendingsDataToContent.get("tab_wydatki_kwota_wydatku_pln").toString();
        for (String oneKosztPln : kosztPlnSplitted = kosztPln.split(";", -1)) {
            if (oneKosztPln == null || oneKosztPln.isEmpty()) continue;
            totalPlnSpendings = totalPlnSpendings + Double.valueOf(oneKosztPln);
        }
        totalTripReward = totalTripReward + totalPlnSpendings;
        Double totalPlnAdvances = 0.0;
        totalPlnAdvances = totalPlnAdvances + (Double)pdfDataContent.get("wartosc_zaliczki_w_pln");
        HashMap<String, Object> dataToSend = new HashMap<String, Object>();
        Double suma_km_pojazd_prywatny = GenerateDocumentBaseOnDelegationModule.obliczIloscKmPrzejechanychWlasnymPojazdem(routeDataToContent);
        dataToSend.put("suma_km_pojazd_prywatny", Tools.formatKwota(Tools.round2(suma_km_pojazd_prywatny)));
        dataToSend.put("calkowita_wartosc_delegacji_pln", Tools.formatKwota(totalTripReward));
        dataToSend.put("wartosc_do_wyplaty_pracownikowi_pln", Tools.formatKwota(totalTripReward - totalPlnAdvances));
        return dataToSend;
    }

    public static double obliczIloscKmPrzejechanychWlasnymPojazdem(Map<String, Object> routeDataToContent) {
        long kmy = 0L;
        String tab_srodek_transportu = routeDataToContent.get("modul_tab_srodek_transportu").toString();
        String[] tab_srodek_transportuSplitted = tab_srodek_transportu.split(";", -1);
        String tab_km = routeDataToContent.get("modul_tab_km").toString();
        String[] tab_kmSplitted = tab_km.split(";", -1);
        for (int i = 0; i < tab_srodek_transportuSplitted.length; ++i) {
            String oneSrodekTransportu = tab_srodek_transportuSplitted[i];
            String oneKm = tab_kmSplitted[i];
            if (!oneSrodekTransportu.contains("Pojazd prywatny")) continue;
            kmy += Math.round(Double.valueOf(oneKm) * 1000.0);
        }
        return (double)kmy / 1000.0;
    }
}

