/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.application;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.HolidaysFunctions;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.database.sequence.SequenceService;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class Integration {
    public static Logger log = Logger.getLogger(Integration.class);

    public static void disconnect(Connection conn) {
        log.trace((Object)"************************* disconnect() ********************");
        long nStart = System.currentTimeMillis();
        try {
            if (conn == null) {
                log.warn((Object)"Polaczenie, ktore mialo byc zamkniete, jest null'em.");
            } else if (conn.isClosed()) {
                log.warn((Object)"Polaczenie, ktore mialo byc zamkniete, jest juz zamkniete.");
            } else {
                conn.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            long nStop = System.currentTimeMillis();
            log.trace((Object)("Disconnected in : " + (nStop - nStart)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> executeQuery(Connection con, String query) throws SQLException {
        log.trace((Object)"************************* executeQuery() ********************");
        long nStart = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rset = null;
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        try {
            if (con != null && !con.isClosed()) {
                log.debug((Object)"ExeccuteQuery: ".concat(query));
                if (query.contains("INSERT") || query.contains("UPDATE")) {
                    stmt = con.createStatement();
                    stmt.executeUpdate(query);
                } else {
                    DatabaseMetaData metaData = con.getMetaData();
                    if (metaData.supportsTransactionIsolationLevel(1)) {
                        con.setTransactionIsolation(1);
                    }
                    stmt = con.createStatement();
                    rset = stmt.executeQuery(query);
                    ResultSetMetaData rsmd = rset.getMetaData();
                    int numColumns = rsmd.getColumnCount();
                    while (rset.next()) {
                        HashMap<String, String> oneRow = new HashMap<String, String>();
                        for (int i = 1; i < numColumns + 1; ++i) {
                            String columnName = rsmd.getColumnName(i);
                            Object obj = rset.getObject(columnName);
                            String value = "";
                            if (obj != null) {
                                value = obj.toString();
                            }
                            oneRow.put(columnName, value);
                        }
                        results.add(oneRow);
                    }
                }
            } else {
                log.debug((Object)"Brak po\u0142\u0105czenia z baz\u0105");
            }
        }
        catch (SQLException e) {
            log.error((Object)"Blad w momencie wywolywania zapytania");
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Blad w momencie zamykania Statement/ResultSet");
                throw e;
            }
        }
        if (log.isTraceEnabled()) {
            long nStop = System.currentTimeMillis();
            log.trace((Object)("Query executed in : " + (nStop - nStart)));
        }
        return results;
    }

    public static HashMap<String, String> executeProcedure(String packageName, String functionName, ArrayList<Object[]> parameters, Connection con) throws Exception {
        log.trace((Object)"************************* excetueProcedure() ********************");
        long nStart = System.currentTimeMillis();
        Statement cstmt = null;
        HashMap<String, String> answer = new HashMap<String, String>();
        try {
            int i;
            String command = "{call ".concat(packageName).concat(".").concat(functionName).concat("(");
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                command = command.concat("?");
                if (i2 == parameters.size() - 1) continue;
                command = command.concat(",");
            }
            command = command.concat(")}");
            log.debug((Object)"Command: ".concat(command));
            ArrayList<Integer> outNrParam = new ArrayList<Integer>();
            cstmt = con.prepareCall(command);
            for (i = 0; i < parameters.size(); ++i) {
                Object[] param = parameters.get(i);
                if (param[1].toString().equalsIgnoreCase("OUT")) {
                    log.debug((Object)("Param " + i + ": TYPE=OUT"));
                    cstmt.registerOutParameter(i + 1, 12);
                    outNrParam.add(i + 1);
                    continue;
                }
                if (param[0] != null) {
                    log.debug((Object)("Param " + i + ": TYPE=IN, VALUE=".concat(param[0].toString())));
                    cstmt.setObject(i + 1, param[0]);
                    continue;
                }
                log.debug((Object)("Param " + i + ": TYPE=IN, VALUE=".concat("NULL")));
                cstmt.setObject(i + 1, "");
            }
            cstmt.execute();
            for (i = 0; i < outNrParam.size(); ++i) {
                String nameParam = parameters.get((Integer)outNrParam.get(i) - 1)[0].toString();
                String odp = cstmt.getString((Integer)outNrParam.get(i));
                if (odp != null) {
                    log.debug((Object)"ODP: ".concat(nameParam).concat(" = ").concat(odp));
                } else {
                    log.debug((Object)"ODP: ".concat(nameParam).concat(" = NULL"));
                }
                answer.put(nameParam, odp);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            long nStop = System.currentTimeMillis();
            log.trace((Object)("Procedure executed in : " + (nStop - nStart)));
        }
        return answer;
    }

    public static String transferTTFCA(Connection connection, Connection connectionDss, Map<String, Object> processContextMap) throws Exception {
        String sequenceName;
        SequenceService sequenceService;
        log.trace((Object)"************************* transferTTFCA() ********************");
        String errMsg = "ok";
        String nrDokumentuId = "";
        String proccessId = "";
        proccessId = processContextMap.get("ProccessId").toString();
        String spolka = (String)processContextMap.get("spolka");
        if (spolka == null) {
            spolka = "DSSPP";
        }
        if (!(sequenceService = ServiceFactory.getSequenceService()).sequenceExist(sequenceName = "ProcesFaktur_transferTTFCA_nrDok")) {
            sequenceService.createSequence(sequenceName, 1, 1);
        }
        long lNNNN = sequenceService.getNextSequenceValue(sequenceName);
        nrDokumentuId = String.valueOf(lNNNN);
        SimpleDateFormat outDf = new SimpleDateFormat("yyyyMMdd");
        String querySatfc = Integration.getQueryFromDB(connection, "proces_faktur", "INSERT satfc");
        Object[] keys = processContextMap.keySet().toArray();
        log.debug((Object)"Aktualizacja tabeli satfc");
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            if (key == null) continue;
            String sValue = null;
            if (processContextMap.get(key) instanceof String) {
                sValue = (String)processContextMap.get(key);
            }
            Double dValue = null;
            if (processContextMap.get(key) instanceof Double) {
                dValue = (Double)processContextMap.get(key);
            }
            String value = sValue;
            if (dValue != null) {
                value = dValue.toString();
            }
            if (key.compareTo("waluta") == 0) {
                if (value.compareTo("PLZ") == 0 || value.compareTo("PLN") == 0) {
                    value = "PLZ";
                    querySatfc = querySatfc.replace("@waluta_typ@", "");
                    querySatfc = querySatfc.replace("@ttvsatfc@", "PL");
                } else {
                    querySatfc = querySatfc.replace("@waluta_typ@", "N");
                    querySatfc = querySatfc.replace("@ttvsatfc@", "IM");
                }
                if (spolka.equals("DSSPP")) {
                    querySatfc = querySatfc.replace("@waluta@", value);
                    continue;
                }
                querySatfc = querySatfc.replace("@waluta@", (String)processContextMap.get(key));
                continue;
            }
            if (key.compareTo("data_wystawienia_faktury") == 0) {
                value = value.replace("/", "-");
                SimpleDateFormat inDf = new SimpleDateFormat("yyyy-MM-dd");
                Calendar c1 = Calendar.getInstance();
                c1.setTime(inDf.parse(value));
                String newDate = outDf.format(c1.getTime());
                querySatfc = querySatfc.replace("@data_wystawienia_faktury@", newDate);
                for (int j = 0; j < 100; ++j) {
                    c1.add(5, -1);
                    int holidayId = HolidaysFunctions.checkHoliday((Calendar)c1, null);
                    if (holidayId == -1) break;
                }
                String sDataFakturyMinusDzien = outDf.format(c1.getTime());
                querySatfc = querySatfc.replace("@data_faktury_minus_dzien@", sDataFakturyMinusDzien);
                continue;
            }
            if (key.compareTo("adres_kontrahenta") == 0) {
                String nrAdresuKontrahenta = value.split(" ")[0];
                if (nrAdresuKontrahenta.compareTo("") == 0) {
                    errMsg = "B\u0142\u0105d podczas pobierania numeru adresu kontrahenta. Pierwsze dwa znaki adresu powinny by\u0107 liczb\u0105";
                    continue;
                }
                querySatfc = querySatfc.replace("@nr_adresu_kontrahenta@", String.valueOf(nrAdresuKontrahenta));
                continue;
            }
            if (value == null) {
                value = "";
            }
            querySatfc = querySatfc.replace("@" + key + "@", value);
        }
        if (errMsg.compareTo("") == 0) {
            Date currentData = new Date();
            querySatfc = querySatfc.replace("@current_date@", outDf.format(currentData.getTime()));
            querySatfc = querySatfc.replace("@nr_adresu_kontrahenta@", "1");
            querySatfc = querySatfc.replace("@nr_adresu_kontrahenta@", "1");
            querySatfc = querySatfc.replace("@nr_dokumentu_int@", nrDokumentuId);
            querySatfc = querySatfc.replace("@spolka@", spolka);
            Integration.executeQuery(connectionDss, querySatfc);
            log.debug((Object)"Aktualizacja tabeli satfl");
            String klasaZamowienia = (String)processContextMap.get("klasa_zamowienia");
            String[] klasaZamowieniaTab = klasaZamowienia.split(";", -1);
            String numerZamowienia = (String)processContextMap.get("numer_zamowienia");
            String[] numerZamowieniaTab = numerZamowienia.split(";", -1);
            String podNumerZamowienia = (String)processContextMap.get("pod_numer_zam");
            String[] podNumerZamowieniaTab = podNumerZamowienia.split(";", -1);
            String querySatfl = Integration.getQueryFromDB(connection, "proces_faktur", "INSERT satfl");
            for (int i = 0; i < klasaZamowieniaTab.length; ++i) {
                Object querySatflBuf = "";
                querySatflBuf = (String)querySatflBuf + querySatfl;
                String nrZam = numerZamowieniaTab[i];
                querySatflBuf = ((String)querySatflBuf).replace("@numer_dokumentu@", nrDokumentuId);
                querySatflBuf = ((String)querySatflBuf).replace("@klasa_zamowienia@", klasaZamowieniaTab[i]);
                querySatflBuf = ((String)querySatflBuf).replace("@numer_zamowienia@", nrZam);
                querySatflBuf = ((String)querySatflBuf).replace("@nussatfl@", String.valueOf(i));
                querySatflBuf = ((String)querySatflBuf).replace("@pod_numer_zamowienia@", podNumerZamowieniaTab[i]);
                querySatflBuf = ((String)querySatflBuf).replace("@current_date@", outDf.format(currentData.getTime()));
                querySatflBuf = ((String)querySatflBuf).replace("@spolka@", spolka);
                Integration.executeQuery(connectionDss, (String)querySatflBuf);
            }
            if (errMsg.compareTo("") == 0) {
                log.debug((Object)"Aktualizacja tabeli satdo");
                String querySatdo = Integration.getQueryFromDB(connection, "proces_faktur", "INSERT satdo");
                querySatdo = querySatdo.replace("@numsatdo@", nrDokumentuId);
                querySatdo = querySatdo.replace("@lcasatdo@", "0");
                querySatdo = querySatdo.replace("@nussatdo@", "1");
                querySatdo = querySatdo.replace("@current_date@", outDf.format(currentData.getTime()));
                querySatdo = querySatdo.replace("@spolka@", spolka);
                DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
                DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
                DocumentClass documentClass = documentClassService.getDocumentClass("Faktury", new String[0]);
                WfFile f = null;
                if (documentClass != null) {
                    Long sDocClassId = documentClass.getId();
                    List processDocuments = documentFinder.getDocumentsFromProcess(proccessId, new String[0]);
                    for (int i = 0; i < processDocuments.size(); ++i) {
                        WfDocument document = (WfDocument)processDocuments.get(i);
                        if (document.getDocumentClassId() != sDocClassId) continue;
                        WfFile wfFile = document.getFile();
                        WfFileVersion wfFileVersion = wfFile.getVersion();
                        f = wfFileVersion.getNewestFile();
                    }
                }
                if (f == null) {
                    errMsg = "B\u0142\u0105d podczas pobierania linku do faktury";
                } else {
                    String fullFileName;
                    String fileName = fullFileName = f.getSystemFileName();
                    int dotIndex = fullFileName.lastIndexOf(".");
                    if (dotIndex != -1) {
                        fileName = fullFileName.substring(0, dotIndex);
                    }
                    querySatdo = querySatdo.replace("@link@", fileName);
                    querySatdo = querySatdo.replace("@link2@", fullFileName);
                    Integration.executeQuery(connectionDss, querySatdo);
                }
            }
        }
        return errMsg;
    }

    public static String transferGECT(Connection connection, Connection connectionDss, Map<String, Object> processContextMap) throws Exception {
        Object status;
        log.trace((Object)"************************* transferGECT() ********************");
        String nrDokumentuId = "";
        SequenceService sequenceService = ServiceFactory.getSequenceService();
        String sequenceName = "ProcesFaktur_transferGECT_nrDok";
        if (!sequenceService.sequenceExist(sequenceName)) {
            sequenceService.createSequence(sequenceName, 1, 1);
        }
        long lNNNN = sequenceService.getNextSequenceValue(sequenceName);
        nrDokumentuId = String.valueOf(lNNNN);
        Date currentData = new Date();
        SimpleDateFormat outDf = new SimpleDateFormat("yyyyMMdd");
        String queryOcect = Integration.getQueryFromDB(connection, "proces_faktur", "INSERT ocect");
        String spolka = (String)processContextMap.get("spolka");
        if (spolka == null) {
            spolka = "DSSPP";
        }
        String nrDokumentu = (String)processContextMap.get("numer_dokumentu");
        String nrFaktury = (String)processContextMap.get("numer_faktury");
        String dataWystawieniaFaktury = (String)processContextMap.get("data_wystawienia_faktury");
        dataWystawieniaFaktury = dataWystawieniaFaktury.replace("/", "-");
        SimpleDateFormat inDf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c1 = Calendar.getInstance();
        c1.setTime(inDf.parse(dataWystawieniaFaktury));
        dataWystawieniaFaktury = outDf.format(c1.getTime());
        for (int j = 0; j < 100; ++j) {
            c1.add(5, -1);
            int holidayId = HolidaysFunctions.checkHoliday((Calendar)c1, null);
            if (holidayId == -1) break;
        }
        String dataPlatnosci = (String)processContextMap.get("termin_platnosci");
        dataPlatnosci = dataPlatnosci.replace("/", "-");
        c1 = Calendar.getInstance();
        c1.setTime(inDf.parse(dataPlatnosci));
        dataPlatnosci = outDf.format(c1.getTime());
        String kodKontrahenta = (String)processContextMap.get("kod_kontrahenta_combo");
        String adresKontrahenta = (String)processContextMap.get("adres_kontrahenta");
        String nrAdresuKontrahenta = adresKontrahenta.split(" ")[0];
        String nrKontaBankowego = (String)processContextMap.get("nr_konta_bankowego");
        String nrBanku = nrKontaBankowego.split(" ")[0];
        Double wartoscBrutto = (Double)processContextMap.get("wartosc_brutto");
        String wartoscBruttoPLN = "null";
        String wartoscBruttoWaluta = "null";
        String waluta = (String)processContextMap.get("waluta");
        String kodWaluty = "";
        String dvmocect = "";
        String dimocect = "";
        String midocect = "null";
        String mtdocect = "null";
        String mtcocect = "null";
        if (waluta.compareTo("PLZ") == 0 || waluta.compareTo("PLN") == 0) {
            wartoscBruttoPLN = wartoscBrutto.toString();
            mtdocect = "0";
            mtcocect = "0";
        } else {
            wartoscBruttoWaluta = wartoscBrutto.toString();
            kodWaluty = waluta;
            dimocect = "N";
            midocect = "0";
        }
        String nrFakturyPierwotnej = (String)processContextMap.get("nr_faktury_pierwotnej");
        String tpiocect = "KD";
        if (nrFakturyPierwotnej.compareTo("") == 0) {
            tpiocect = "FD";
        }
        String dataRejestracji = (String)processContextMap.get("data_rejestracji");
        dataRejestracji = dataRejestracji.replace("/", "-");
        c1 = Calendar.getInstance();
        c1.setTime(inDf.parse(dataRejestracji));
        dataRejestracji = outDf.format(c1.getTime());
        int licznik = 0;
        log.debug((Object)"Pobranie numeru transferu");
        String queryNuiocect = "select nvl(max(nuiocect),10000)+1 as NUIOCECT from ocect";
        List<Map<String, String>> resultQueryNuiocect = Integration.executeQuery(connectionDss, queryNuiocect);
        if (resultQueryNuiocect.size() <= 0) {
            String status2 = "Brak wynik\u00f3w dla zapytania: " + resultQueryNuiocect;
            log.debug((Object)status2);
            return status2;
        }
        licznik = Integer.valueOf(resultQueryNuiocect.get(0).get("NUIOCECT"));
        String sLicznik = String.valueOf(licznik);
        String didocect = "";
        String vprocect = "null";
        String valoedvc = "";
        if (waluta.compareTo("PLZ") != 0 && waluta.compareTo("PLN") != 0) {
            log.debug((Object)"Pobranie kursu oraz daty kursu z Qualiac");
            String queryKurs = "SELECT DDVOEDVC, VALOEDVC FROM (select * from KURSY order by DDVOEDVC desc) WHERE ROWNUM = 1 and DEVOEDVC = '@waluta@' and DDVOEDVC < @datafaktury@";
            queryKurs = queryKurs.replace("@waluta@", waluta);
            queryKurs = queryKurs.replace("@datafaktury@", dataWystawieniaFaktury);
            List<Map<String, String>> resultQueryKursy = Integration.executeQuery(connectionDss, queryKurs);
            if (resultQueryKursy.size() > 0) {
                didocect = resultQueryKursy.get(0).get("DDVOEDVC");
                valoedvc = resultQueryKursy.get(0).get("VALOEDVC");
            } else {
                String status3 = "Brak wynik\u00f3w dla zapytania: " + queryKurs;
                log.debug((Object)status3);
                return status3;
            }
        }
        log.debug((Object)"Pobranie rgmocect z Qualiac");
        String queryRgmocect = Integration.getQueryFromDB(connection, "proces_faktur", "GECT, rgmocect");
        queryRgmocect = queryRgmocect.replace("@kod_kontrahenta@", kodKontrahenta);
        queryRgmocect = queryRgmocect.replace("@spolka@", spolka);
        List<Map<String, String>> resultQueryRgmocect = Integration.executeQuery(connectionDss, queryRgmocect);
        String rgmocect = "";
        String rgdocect = "";
        String rgjocect = "";
        if (resultQueryRgmocect.size() <= 0) {
            String status4 = "Brak wynik\u00f3w dla zapytania: " + queryRgmocect;
            log.debug((Object)status4);
            return status4;
        }
        rgmocect = resultQueryRgmocect.get(0).get("SPOSOB");
        rgdocect = resultQueryRgmocect.get(0).get("TERMIN");
        rgjocect = resultQueryRgmocect.get(0).get("DNI");
        if (rgmocect.compareTo("") == 0 || rgdocect.compareTo("") == 0 || rgjocect.compareTo("") == 0) {
            String status5 = "Brak wynik\u00f3w dla zapytania: " + queryRgmocect;
            log.debug((Object)status5);
            return status5;
        }
        String queryOcect_naglowek = queryOcect;
        queryOcect_naglowek = queryOcect_naglowek.replace("@NUIOCECT@", sLicznik);
        queryOcect_naglowek = queryOcect_naglowek.replace("@ETSOCECT@", spolka);
        queryOcect_naglowek = queryOcect_naglowek.replace("@TYPOCECT@", "C");
        queryOcect_naglowek = queryOcect_naglowek.replace("@NUMOCECT@", nrDokumentuId);
        queryOcect_naglowek = queryOcect_naglowek.replace("@JRNOCECT@", "ZAWF");
        queryOcect_naglowek = queryOcect_naglowek.replace("@DCROCECT@", outDf.format(currentData.getTime()));
        queryOcect_naglowek = queryOcect_naglowek.replace("@UCROCECT@", "WORKFLOW");
        queryOcect_naglowek = queryOcect_naglowek.replace("@LIBOCECT@", nrDokumentu + outDf.format(currentData.getTime()));
        queryOcect_naglowek = queryOcect_naglowek.replace("@LICOCECT@", nrDokumentu);
        queryOcect_naglowek = queryOcect_naglowek.replace("@DECOCECT@", outDf.format(currentData.getTime()));
        queryOcect_naglowek = queryOcect_naglowek.replace("@DEMOCECT@", dataWystawieniaFaktury);
        queryOcect_naglowek = queryOcect_naglowek.replace("@ECHOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@CPTOCECT@", "KONTO");
        queryOcect_naglowek = queryOcect_naglowek.replace("@MTDOCECT@", mtdocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@MTCOCECT@", wartoscBruttoPLN);
        queryOcect_naglowek = queryOcect_naglowek.replace("@NECOCECT@", "1");
        queryOcect_naglowek = queryOcect_naglowek.replace("@CGROCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@BUDOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@DOSOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@TVAOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@LIMOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@MIDOCECT@", midocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@MICOCECT@", wartoscBruttoWaluta);
        queryOcect_naglowek = queryOcect_naglowek.replace("@PIEOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@TPIOCECT@", tpiocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@TIEOCECT@", kodKontrahenta);
        queryOcect_naglowek = queryOcect_naglowek.replace("@TIAOCECT@", nrAdresuKontrahenta);
        queryOcect_naglowek = queryOcect_naglowek.replace("@TIDOCECT@", nrBanku);
        queryOcect_naglowek = queryOcect_naglowek.replace("@RGMOCECT@", rgmocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@DEVOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@DIDOCECT@", didocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@VPROCECT@", vprocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@DIMOCECT@", dimocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@UNOOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@QUOOCECT@", "0");
        queryOcect_naglowek = queryOcect_naglowek.replace("@BHTOCECT@", "null");
        queryOcect_naglowek = queryOcect_naglowek.replace("@MHTOCECT@", "null");
        queryOcect_naglowek = queryOcect_naglowek.replace("@MTVOCECT@", "null");
        queryOcect_naglowek = queryOcect_naglowek.replace("@ECIOCECT@", dataPlatnosci);
        queryOcect_naglowek = queryOcect_naglowek.replace("@DOEOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@TMSOCECT@", "1");
        queryOcect_naglowek = queryOcect_naglowek.replace("@PIXOCECT@", nrFaktury);
        queryOcect_naglowek = queryOcect_naglowek.replace("@DVMOCECT@", dvmocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@MDDOCECT@", "null");
        queryOcect_naglowek = queryOcect_naglowek.replace("@MDCOCECT@", "null");
        queryOcect_naglowek = queryOcect_naglowek.replace("@RGJOCECT@", rgjocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@RGDOCECT@", rgdocect);
        queryOcect_naglowek = queryOcect_naglowek.replace("@DDVOCECT@", "");
        queryOcect_naglowek = queryOcect_naglowek.replace("@DVLOCECT@", dataRejestracji);
        queryOcect_naglowek = queryOcect_naglowek.replace("@DIVOCECT@", kodWaluty);
        queryOcect_naglowek = queryOcect_naglowek.replace("@VIROCECT@", valoedvc);
        Integration.executeQuery(connectionDss, queryOcect_naglowek);
        ++licznik;
        String kodVat = (String)processContextMap.get("kod_vat");
        String stawkaVat = (String)processContextMap.get("stawka_vat");
        String wartoscVat = (String)processContextMap.get("wartosc_vat");
        String[] stawkaVatTab = stawkaVat.split(";", -1);
        String[] kodVatTab = kodVat.split(";", -1);
        log.debug((Object)"Pobranie z qualiaca danej 'cptocect'");
        String queryCptocect = Integration.getQueryFromDB(connection, "proces_faktur", "GECT, cptocect");
        if (kodVat.compareTo("") != 0) {
            String[] wartoscVatTab = wartoscVat.split(";", -1);
            for (int i = 0; i < kodVatTab.length; ++i) {
                String queryCptocectRec = queryCptocect.replace("@kod_vat@", kodVatTab[i]);
                queryCptocectRec = queryCptocectRec.replace("@spolka@", spolka);
                List<Map<String, String>> resultQueryCptocectRec = Integration.executeQuery(connectionDss, queryCptocectRec);
                String cpcoetva = "";
                if (resultQueryCptocectRec.size() > 0) {
                    cpcoetva = resultQueryCptocectRec.get(0).get("CPCOETVA");
                    if (cpcoetva.compareTo("") == 0) {
                        cpcoetva = "null";
                    }
                } else {
                    status = "Brak wynikow dla zapytania:" + queryCptocectRec;
                    log.debug(status);
                    return status;
                }
                if (cpcoetva.equalsIgnoreCase("null")) continue;
                sLicznik = String.valueOf(licznik);
                String wartoscVatPln = "null";
                String wartoscVatWaluta = "null";
                String micocect = "null";
                if (waluta.compareTo("PLZ") == 0 || waluta.compareTo("PLN") == 0) {
                    wartoscVatPln = wartoscVatTab[i];
                } else {
                    micocect = "0";
                    wartoscVatWaluta = wartoscVatTab[i];
                }
                String queryOcect_vat = queryOcect;
                queryOcect_vat = queryOcect_vat.replace("@NUIOCECT@", sLicznik);
                queryOcect_vat = queryOcect_vat.replace("@ETSOCECT@", spolka);
                queryOcect_vat = queryOcect_vat.replace("@TYPOCECT@", "C");
                queryOcect_vat = queryOcect_vat.replace("@NUMOCECT@", nrDokumentuId);
                queryOcect_vat = queryOcect_vat.replace("@JRNOCECT@", "ZAWF");
                queryOcect_vat = queryOcect_vat.replace("@DCROCECT@", outDf.format(currentData.getTime()));
                queryOcect_vat = queryOcect_vat.replace("@UCROCECT@", "WORKFLOW");
                queryOcect_vat = queryOcect_vat.replace("@LIBOCECT@", nrDokumentu + outDf.format(currentData.getTime()));
                queryOcect_vat = queryOcect_vat.replace("@LICOCECT@", nrDokumentu);
                queryOcect_vat = queryOcect_vat.replace("@DECOCECT@", outDf.format(currentData.getTime()));
                queryOcect_vat = queryOcect_vat.replace("@DEMOCECT@", dataWystawieniaFaktury);
                queryOcect_vat = queryOcect_vat.replace("@ECHOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@CPTOCECT@", cpcoetva);
                queryOcect_vat = queryOcect_vat.replace("@MTDOCECT@", wartoscVatPln);
                queryOcect_vat = queryOcect_vat.replace("@MTCOCECT@", mtcocect);
                queryOcect_vat = queryOcect_vat.replace("@NECOCECT@", "0");
                queryOcect_vat = queryOcect_vat.replace("@CGROCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@BUDOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DOSOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@TVAOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@LIMOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@MIDOCECT@", wartoscVatWaluta);
                queryOcect_vat = queryOcect_vat.replace("@MICOCECT@", micocect);
                queryOcect_vat = queryOcect_vat.replace("@PIEOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@TPIOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@TIEOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@TIAOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@TIDOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@RGMOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DEVOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DIDOCECT@", didocect);
                queryOcect_vat = queryOcect_vat.replace("@VPROCECT@", vprocect);
                queryOcect_vat = queryOcect_vat.replace("@DIMOCECT@", dimocect);
                queryOcect_vat = queryOcect_vat.replace("@UNOOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@QUOOCECT@", "0");
                queryOcect_vat = queryOcect_vat.replace("@BHTOCECT@", "null");
                queryOcect_vat = queryOcect_vat.replace("@MHTOCECT@", "null");
                queryOcect_vat = queryOcect_vat.replace("@MTVOCECT@", "null");
                queryOcect_vat = queryOcect_vat.replace("@ECIOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DOEOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@TMSOCECT@", "1");
                queryOcect_vat = queryOcect_vat.replace("@PIXOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DVMOCECT@", dvmocect);
                queryOcect_vat = queryOcect_vat.replace("@MDDOCECT@", "null");
                queryOcect_vat = queryOcect_vat.replace("@MDCOCECT@", "null");
                queryOcect_vat = queryOcect_vat.replace("@RGJOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@RGDOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DDVOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DVLOCECT@", "");
                queryOcect_vat = queryOcect_vat.replace("@DIVOCECT@", kodWaluty);
                queryOcect_vat = queryOcect_vat.replace("@VIROCECT@", valoedvc);
                Integration.executeQuery(connectionDss, queryOcect_vat);
                ++licznik;
            }
        }
        String konto = (String)processContextMap.get("konto");
        String mpk = (String)processContextMap.get("mpk");
        String wartoscDekretacji = (String)processContextMap.get("wartosc_tab_dekretacji");
        String nrLiniiVat = (String)processContextMap.get("nr_linii_vat");
        String opisTransakcji = null;
        if (processContextMap.containsKey("opis_transakcji")) {
            opisTransakcji = (String)processContextMap.get("opis_transakcji");
        }
        if (konto.compareTo("") != 0) {
            String[] kontoTab = konto.split(";", -1);
            String[] mpkTab = mpk.split(";", -1);
            String[] wartoscDekretacjiTab = wartoscDekretacji.split(";", -1);
            String[] nrLiniiVatTab = nrLiniiVat.split(";", -1);
            String[] opisTransakcjiTab = null;
            if (opisTransakcji != null) {
                opisTransakcjiTab = opisTransakcji.split(";", -1);
            }
            for (int i = 0; i < kontoTab.length; ++i) {
                sLicznik = String.valueOf(licznik);
                String sNrLiniiVat = nrLiniiVatTab[i];
                int iNrLiniiVat = 1;
                if (sNrLiniiVat.compareTo("") != 0 && (iNrLiniiVat = Integer.valueOf(sNrLiniiVat).intValue()) == 0) {
                    iNrLiniiVat = 1;
                }
                String limocect = "";
                if (opisTransakcjiTab != null) {
                    limocect = opisTransakcjiTab[i];
                }
                String wartoscPln = "null";
                String wartoscWaluta = "null";
                String kwotaVat = "null";
                String micocect = "null";
                wartoscWaluta = wartoscDekretacjiTab[i];
                double dWartosc = Double.valueOf(wartoscWaluta);
                double stawkaVatLinii = Double.valueOf(stawkaVatTab[iNrLiniiVat - 1]);
                double dVat = stawkaVatLinii / 100.0 * dWartosc;
                dVat = CUFTools.Round((Double)dVat, (int)2);
                kwotaVat = String.valueOf(dVat);
                if (waluta.compareTo("PLZ") == 0 || waluta.compareTo("PLN") == 0) {
                    wartoscWaluta = "null";
                    wartoscPln = wartoscDekretacjiTab[i];
                } else {
                    micocect = "0";
                }
                log.debug((Object)"Pobranie BUDOCECT i STVOECPT z Qualiac");
                String stvoecpt = "";
                String queryBudocect = Integration.getQueryFromDB(connection, "proces_faktur", "GECT, Budocect");
                queryBudocect = queryBudocect.replace("@konto@", kontoTab[i]);
                queryBudocect = queryBudocect.replace("@spolka@", spolka);
                List<Map<String, String>> resultQueryBudocect = Integration.executeQuery(connectionDss, queryBudocect);
                String budocect = "";
                if (resultQueryBudocect.size() > 0) {
                    budocect = resultQueryBudocect.get(0).get("CGBOECPT");
                    stvoecpt = resultQueryBudocect.get(0).get("STVOECPT");
                    if (budocect == null) {
                        budocect = "";
                    }
                    if (stvoecpt == null) {
                        stvoecpt = "";
                    }
                } else {
                    String status6 = "Brak wynik\u00f3w dla zapytania: " + queryBudocect;
                    log.debug((Object)status6);
                    return status6;
                }
                log.debug((Object)("CGBOECPT: " + budocect + ", STVOECPT:" + stvoecpt));
                String tvaocect = "";
                String bhtocect = "null";
                String mhtocect = "null";
                String mtvocect = "null";
                if (stvoecpt.compareToIgnoreCase("TAK") == 0) {
                    log.debug((Object)"stvoecpt = Tak. Przypisujemy dane");
                    tvaocect = kodVatTab[iNrLiniiVat - 1];
                    bhtocect = wartoscDekretacjiTab[i];
                    mhtocect = wartoscDekretacjiTab[i];
                    mtvocect = kwotaVat;
                    log.debug((Object)("tvaocect= " + tvaocect + ", bhtocect/mhtocect= " + mhtocect + ", mtvocect= " + kwotaVat));
                }
                String insertQuery = "INSERT INTO ocect (NUIOCECT, ETSOCECT, TYPOCECT, NUMOCECT, JRNOCECT, DCROCECT, UCROCECT, LIBOCECT, LICOCECT, DECOCECT, DEMOCECT, ECHOCECT, CPTOCECT, MTDOCECT, MTCOCECT, NECOCECT, CGROCECT, BUDOCECT, DOSOCECT, TVAOCECT, LIMOCECT, MIDOCECT, MICOCECT, PIEOCECT, TPIOCECT, TIEOCECT, TIAOCECT, TIDOCECT, RGMOCECT, DEVOCECT, DIDOCECT, VPROCECT, DIMOCECT, UNOOCECT, QUOOCECT, BHTOCECT, MHTOCECT, MTVOCECT, ECIOCECT, DOEOCECT, TMSOCECT, PIXOCECT, DVMOCECT, MDDOCECT, MDCOCECT, RGJOCECT, RGDOCECT, DDVOCECT, DVLOCECT, DIVOCECT, VIROCECT) VALUES (" + sLicznik + ", '" + (spolka == null ? "" : spolka) + "', 'C', '" + (nrDokumentuId == null ? "" : nrDokumentuId) + "', 'ZAWF', '" + outDf.format(currentData.getTime()) + "', 'WORKFLOW', '" + nrDokumentu + outDf.format(currentData.getTime()) + "', '" + nrDokumentu + "', '" + outDf.format(currentData.getTime()) + "', '" + dataWystawieniaFaktury + "', '', '" + kontoTab[i] + "', " + (wartoscPln.compareTo("null") == 0 ? "null" : wartoscPln.replace(",", ".")) + ", " + (mtcocect.compareTo("null") == 0 ? "null" : mtcocect.replace(",", ".")) + ", 0, '" + mpkTab[i] + "', '" + budocect + "', '', '" + tvaocect + "', '" + limocect + "', " + (wartoscWaluta.compareTo("null") == 0 ? "null" : wartoscWaluta.replace(",", ".")) + ", " + (micocect.compareTo("null") == 0 ? "null" : micocect.replace(",", ".")) + ", '', '', '', '', '', '', '', '" + didocect + "', " + (vprocect.compareTo("null") == 0 ? "null" : vprocect.replace(",", ".")) + ", '" + dimocect + "', '', 0.0, " + (bhtocect.compareTo("null") == 0 ? "null" : bhtocect.replace(",", ".")) + ", " + (mhtocect.compareTo("null") == 0 ? "null" : mhtocect.replace(",", ".")) + ", " + (mtvocect.compareTo("null") == 0 ? "null" : mtvocect.replace(",", ".")) + ", '', '', 1, '', '" + dvmocect + "', null, null, '', '', '', '', '" + kodWaluty + "', " + (valoedvc.compareTo("") == 0 ? "null" : valoedvc.replace(",", ".")) + ")";
                Integration.executeQuery(connectionDss, insertQuery);
                ++licznik;
            }
        }
        status = "ok";
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{nrDokumentuId, "IN"});
        log.debug((Object)"Wywolanie procedury KONTO_OCECT");
        Integration.executeProcedure("mpm", "KONTO_OCECT", parameters, connectionDss);
        log.debug((Object)"Wywolanie procedury DOPISZ_OCECT");
        Integration.executeProcedure("mpm", "DOPISZ_OCECT", parameters, connectionDss);
        List<Map<String, String>> resultQueryKomunikat = Integration.executeQuery(connectionDss, "select KOMUNIKAT, SYSDATA from komunikat");
        if (resultQueryKomunikat.size() > 0) {
            String komunikat = resultQueryKomunikat.get(0).get("KOMUNIKAT");
            String sysdate = resultQueryKomunikat.get(0).get("SYSDATA");
            if (!komunikat.startsWith("OK:")) {
                status = "Wyst\u0105pi\u0142 b\u0142\u0105d transeru. SYSDATA komunikatu:" + sysdate + " Komunikat z IFS: " + komunikat;
            }
        }
        return status;
    }

    public static String transferGECT(Connection connection, Connection connectionDss, List<Map<String, String>> data) throws Exception {
        log.trace((Object)"************************* transferGECT() ********************");
        String nrDokumentuId = "";
        int licznik = 0;
        log.debug((Object)"Pobranie numeru transferu");
        String queryNuiocect = "select nvl(max(nuiocect),10000)+1 as NUIOCECT from ocect";
        List<Map<String, String>> resultQueryNuiocect = Integration.executeQuery(connectionDss, queryNuiocect);
        if (resultQueryNuiocect.size() <= 0) {
            String status = "Brak wynik\u00f3w dla zapytania: " + resultQueryNuiocect;
            log.debug((Object)status);
            return status;
        }
        licznik = Integer.valueOf(resultQueryNuiocect.get(0).get("NUIOCECT"));
        String sLicznik = String.valueOf(licznik);
        String queryOcect = Integration.getQueryFromDB(connection, "proces_faktur", "INSERT ocect");
        for (int i = 0; i < data.size(); ++i) {
            String queryOcect_naglowek = queryOcect;
            queryOcect_naglowek = queryOcect_naglowek.replace("@NUIOCECT@", sLicznik);
            queryOcect_naglowek = queryOcect_naglowek.replace("@ETSOCECT@", data.get(i).get("ETSOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@TYPOCECT@", data.get(i).get("TYPOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@NUMOCECT@", data.get(i).get("NUMOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@JRNOCECT@", data.get(i).get("JRNOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DCROCECT@", data.get(i).get("DCROCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@UCROCECT@", data.get(i).get("UCROCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@LIBOCECT@", data.get(i).get("LIBOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@LICOCECT@", data.get(i).get("LICOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DECOCECT@", data.get(i).get("DECOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DEMOCECT@", data.get(i).get("DEMOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@ECHOCECT@", data.get(i).get("ECHOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@CPTOCECT@", data.get(i).get("CPTOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MTDOCECT@", data.get(i).get("MTDOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MTCOCECT@", data.get(i).get("MTCOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@NECOCECT@", data.get(i).get("NECOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@CGROCECT@", data.get(i).get("CGROCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@BUDOCECT@", data.get(i).get("BUDOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DOSOCECT@", data.get(i).get("DOSOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@TVAOCECT@", data.get(i).get("TVAOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@LIMOCECT@", data.get(i).get("LIMOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MIDOCECT@", data.get(i).get("MIDOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MICOCECT@", data.get(i).get("MICOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@PIEOCECT@", data.get(i).get("PIEOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@TPIOCECT@", data.get(i).get("TPIOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@TIEOCECT@", data.get(i).get("TIEOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@TIAOCECT@", data.get(i).get("TIAOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@TIDOCECT@", data.get(i).get("TIDOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@RGMOCECT@", data.get(i).get("RGMOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DEVOCECT@", data.get(i).get("DEVOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DIDOCECT@", data.get(i).get("DIDOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@VPROCECT@", data.get(i).get("VPROCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DIMOCECT@", data.get(i).get("DIMOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@UNOOCECT@", data.get(i).get("UNOOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@QUOOCECT@", data.get(i).get("QUOOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@BHTOCECT@", data.get(i).get("BHTOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MHTOCECT@", data.get(i).get("MHTOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MTVOCECT@", data.get(i).get("MTVOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@ECIOCECT@", data.get(i).get("ECIOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DOEOCECT@", data.get(i).get("DOEOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@TMSOCECT@", data.get(i).get("TMSOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@PIXOCECT@", data.get(i).get("PIXOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DVMOCECT@", data.get(i).get("DVMOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MDDOCECT@", data.get(i).get("MDDOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@MDCOCECT@", data.get(i).get("MDCOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@RGJOCECT@", data.get(i).get("RGJOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@RGDOCECT@", data.get(i).get("RGDOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DDVOCECT@", data.get(i).get("DDVOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DVLOCECT@", data.get(i).get("DVLOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@DIVOCECT@", data.get(i).get("DIVOCECT"));
            queryOcect_naglowek = queryOcect_naglowek.replace("@VIROCECT@", data.get(i).get("VIROCECT"));
            Integration.executeQuery(connectionDss, queryOcect_naglowek);
            sLicznik = String.valueOf(++licznik);
        }
        Object status = "ok";
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{nrDokumentuId, "IN"});
        log.debug((Object)"Wywolanie procedury KONTO_OCECT");
        Integration.executeProcedure("mpm", "KONTO_OCECT", parameters, connectionDss);
        log.debug((Object)"Wywolanie procedury DOPISZ_OCECT");
        Integration.executeProcedure("mpm", "DOPISZ_OCECT", parameters, connectionDss);
        List<Map<String, String>> resultQueryKomunikat = Integration.executeQuery(connectionDss, "select KOMUNIKAT, SYSDATA from komunikat");
        if (resultQueryKomunikat.size() > 0) {
            String komunikat = resultQueryKomunikat.get(0).get("KOMUNIKAT");
            String sysdate = resultQueryKomunikat.get(0).get("SYSDATA");
            if (!komunikat.startsWith("OK:")) {
                status = "Wyst\u0105pi\u0142 b\u0142\u0105d transeru. SYSDATA komunikatu:" + sysdate + " Komunikat z IFS: " + komunikat;
            }
            status = "test";
        }
        return status;
    }

    private static String getQueryFromDB(Connection con, String processid, String queryName) {
        log.trace((Object)"************************* getQueryFromDB() ********************");
        String queryResult = "";
        try {
            SQLFinder sqlFinder = FinderFactory.getSQLFinder();
            SQLBuilder sqlBuilder = new SQLBuilder();
            sqlBuilder.setQuery("SELECT query FROM pm_cust_queries");
            sqlBuilder.addScalar("query", (Type)StandardBasicTypes.STRING);
            sqlBuilder.addFilter((SQLFilter)new SimpleSQLFilter("processid", (Object)processid, FilterOperator.EQ));
            sqlBuilder.addFilter((SQLFilter)new SimpleSQLFilter("name", (Object)queryName, FilterOperator.EQ));
            List result = sqlFinder.find(sqlBuilder);
            if (result.size() > 0 && result.get(0) != null && ((Map)result.get(0)).get("query") != null) {
                queryResult = ((Map)result.get(0)).get("query").toString();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return queryResult;
    }
}

