/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.spring.controller;

import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/account"})
public class AccountNumbersController {
    public static Logger log = Logger.getLogger(AccountNumbersController.class);

    @RequestMapping(value={"getaccountnumbers"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] getAccountNumbers(@RequestParam(value="contractor_number") String contractorNumber) throws Exception {
        String query = this.getQuery("pzk_nr_rachunku_bankowego_wszystkie_dane");
        SQLFinder sqlFinder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery(query);
        builder.addScalar("nr_rachunku", (Type)StandardBasicTypes.STRING);
        builder.addScalar("nr_kontrahenta", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("nr_kontrahenta", (Object)contractorNumber));
        List data = sqlFinder.find(builder);
        String[] rachunki = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            Map oneData = (Map)data.get(i);
            rachunki[i] = oneData.get("nr_rachunku").toString();
        }
        return rachunki;
    }

    private String getQuery(String queryName) {
        SQLFinder sqlFinder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select * from pm_dbqueries where query_name=:textvalue");
        builder.addScalar("query", (Type)StandardBasicTypes.STRING);
        builder.setParameter("textvalue", (Object)queryName);
        List data = sqlFinder.find(builder);
        String query = "";
        query = ((Map)data.get(0)).get("query").toString();
        return query;
    }
}

