/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.automatictasks;

import com.suncode.plugin.categories.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

@Application
public class AttachDocumentToProcess {
    public static Logger log = Logger.getLogger(AttachDocumentToProcess.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("attach-document-to-process-dss-app")).name("attach-document-to-process-dss-app.name")).description("attach-document-to-process-dss-app.desc")).category(new Category[]{Categories.DSSTOOLS})).icon((Icon)SilkIconPack.PAGE)).parameter().id("processid").name("attach-document-to-process-dss-app-processid.name").type((Type)Types.STRING).create()).parameter().id("activityid").name("attach-document-to-process-dss-app-activityid.name").type((Type)Types.STRING).create();
    }

    public void execute(@Param String processid, @Param String activityid) throws Exception {
        try {
            log.debug((Object)"Start zadania automatycznego.");
            ActivityService activityService = ServiceFactory.getActivityService();
            DocumentService documentService = ServiceFactory.getDocumentService();
            DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            Map activityData = activityService.getActivityContext(processid, activityid);
            if (activityData.containsKey("spolka")) {
                String spolka;
                String string = spolka = activityData.get("spolka") == null ? "" : activityData.get("spolka").toString();
                if (spolka.compareTo("DSSSL") == 0) {
                    DocumentClass documentClass = documentClassService.getDocumentClass("Faktury elektroniczne- eml", new String[]{"indexes"});
                    Set indexes = documentClass.getIndexes();
                    String nadawcaEmail = activityData.get("nadawca_email") == null ? "" : activityData.get("nadawca_email").toString();
                    String dataWplywu = activityData.get("data_wplywu") == null ? "" : activityData.get("data_wplywu").toString();
                    String tematWiadomosciEmail = activityData.get("temat_wiadomosci_email") == null ? "" : activityData.get("temat_wiadomosci_email").toString();
                    HashMap<Long, Object> idx = new HashMap<Long, Object>();
                    for (DocumentClassIndex oneIndex : indexes) {
                        if (oneIndex.getName().compareTo("Sp\u00f3\u0142ka") == 0) {
                            idx.put(oneIndex.getId(), spolka);
                            continue;
                        }
                        if (oneIndex.getName().compareTo("Nadawca") == 0) {
                            idx.put(oneIndex.getId(), nadawcaEmail);
                            continue;
                        }
                        if (oneIndex.getName().compareTo("Temat") == 0) {
                            idx.put(oneIndex.getId(), tematWiadomosciEmail);
                            continue;
                        }
                        if (oneIndex.getName().compareTo("Data wplywu") != 0) continue;
                        idx.put(oneIndex.getId(), DateUtils.parseDate((String)dataWplywu, (String[])new String[]{"yyyy-MM-dd"}));
                    }
                    ArrayList sorters = new ArrayList();
                    CountedResult result = documentFinder.findByIndexes(documentClass.getId(), idx, sorters, Integer.valueOf(0), Integer.valueOf(100), new String[0]);
                    List documents = result.getData();
                    for (WfDocument wfDocument : documents) {
                        documentService.attachDocumentToProcess(wfDocument, "admin", processid, activityid);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

