/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.validators;

import com.suncode.plugin.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import org.apache.log4j.Logger;
import org.iban4j.IbanFormatException;
import org.iban4j.IbanUtil;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;

@Validator
public class ValidateIBAN {
    public static Logger log = Logger.getLogger(ValidateIBAN.class);

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("validate-iban.id")).name("validate-iban.name")).description("validate-iban.desc")).category(new Category[]{Categories.CUSTOM_DSS})).parameter().id("iban_param").name("validator.iban_param.parameter.name").type((Type)Types.VARIABLE).create();
    }

    public void validate(@Param(value="iban_param") Variable iban, ValidationContext validationContext, ActivityContextMap activityContext, ValidationErrors errors, Translator translator) {
        boolean correctIban = true;
        int i = 0;
        try {
            log.debug(iban.getValue());
            String[] values = (String[])iban.getValue();
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].isEmpty()) continue;
                log.debug((Object)("Iban " + i + ": " + values[i].toString()));
                IbanUtil.validate((String)values[i].toString());
            }
        }
        catch (IbanFormatException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
            correctIban = false;
        }
        catch (InvalidCheckDigitException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            correctIban = false;
        }
        catch (UnsupportedCountryException e3) {
            log.error((Object)e3.getMessage(), (Throwable)e3);
            correctIban = false;
        }
        if (!correctIban) {
            errors.add("Nieprawid\u0142owy format rachunku bankowego.", iban.getId(), i);
        }
    }
}

