/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.webservice.hendler;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapXmlLog
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger log = LoggerFactory.getLogger(SoapXmlLog.class);
    private final String name;

    public SoapXmlLog(String titleLog) {
        this.name = titleLog;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        this.logXML(context);
        return true;
    }

    private void logXML(SOAPMessageContext context) throws TransformerFactoryConfigurationError {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            Source soapContent = context.getMessage().getSOAPPart().getContent();
            ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
            StreamResult result = new StreamResult((OutputStream)streamOut);
            transformer.transform(soapContent, result);
            StringBuilder sb = new StringBuilder("\n******  SOAP XML ******");
            sb.append("\n******  " + this.name + " ******");
            sb.append("\n\n");
            sb.append(streamOut.toString());
            sb.append("\n\n");
            sb.append("***********************");
            log.debug(sb.toString());
        }
        catch (SOAPException | TransformerException e) {
            log.debug(e.getMessage(), e);
        }
    }

    public Set<QName> getHeaders() {
        return new TreeSet<QName>();
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.logXML(context);
        return false;
    }

    public void close(MessageContext context) {
        log.debug(context.toString());
    }
}

