/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.test;

import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.exception.JDEException;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.hendler.SoapXmlLog;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.BusinessServiceException;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookAddressVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookManager;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookVoOutput;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.PortInfo;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAddressBookManager {
    private static final Logger log = LoggerFactory.getLogger(TestAddressBookManager.class);

    public static void main(String[] args) throws IOException, Exception {
        final HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        HostnameVerifier localhostAcceptedHostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                if (hostname.equals("localhost")) {
                    return true;
                }
                return defaultHostnameVerifier.verify(hostname, sslSession);
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(localhostAcceptedHostnameVerifier);
        LocalDateTime localDateTime = new LocalDateTime((Object)"2020-01-01");
        XMLGregorianCalendar date = Functions.toXMLGregorianCalendar(localDateTime);
        SuncodeExportAddressBookVoOutput response = TestAddressBookManager.getJDEDate(date);
        if (response == null) {
            return;
        }
        List<E1XeltoMessage> e1Messages = response.getE1Messages();
        for (E1XeltoMessage e1XeltoMessage : e1Messages) {
            log.debug(e1XeltoMessage.getMessage() + "\t" + e1XeltoMessage.getFileName());
        }
        List<SuncodeExportAddressBookAddressVoOutput> addresses = response.getAddresses();
        int responseStatus = response.getResponseStatus();
        log.debug("" + responseStatus);
        log.debug("Size:\t" + addresses.size());
        for (SuncodeExportAddressBookAddressVoOutput voOutput : addresses) {
            log.debug(voOutput.getAddressNumber() + "\t" + voOutput.getNameMailing() + "\t" + voOutput.getAddress());
        }
    }

    private static SuncodeExportAddressBookVoOutput getJDEDate(XMLGregorianCalendar date) throws Exception {
        String SERVICE_NAME = "SuncodeExportAddressBookManager";
        URL wsdlUrl = new URL("https://<127.0.0.1>:8285/DY910/" + SERVICE_NAME + "?wsdl");
        SuncodeExportAddressBookManagerService service = new SuncodeExportAddressBookManagerService(wsdlUrl);
        service.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new SOAPHeaderHandler("BSSVSUNCOD", "suncod"));
                handlerList.add((Handler)new SoapXmlLog("DEBUG SOAP XML"));
                return handlerList;
            }
        });
        SuncodeExportAddressBookManager port = service.getSuncodeExportAddressBookManagerPort();
        SuncodeExportAddressBookVoInput voInput = new SuncodeExportAddressBookVoInput();
        voInput.setUpdateDateFrom(date);
        SuncodeExportAddressBookVoOutput response = null;
        try {
            response = port.suncodeExportAddressBook(voInput);
        }
        catch (BusinessServiceException_Exception bSE) {
            BusinessServiceException info = bSE.getFaultInfo();
            String infoMSG = info.getMessage();
            String infoRequest = info.getRequestID();
            String msg = bSE.getMessage();
            log.error("InfoMSG: " + infoMSG + " RequestID: " + infoRequest + "ErrorMSG: " + msg, (Throwable)bSE);
        }
        catch (Exception e) {
            log.debug("JDE Service Error:\t" + e.getMessage(), (Throwable)e);
            throw new JDEException(e.getMessage());
        }
        return response;
    }
}

