/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.scheduledtask;

import com.suncode.plugin.drosed.db.service.PurchaseOrdersOrder2Service;
import com.suncode.plugin.drosed.db.service.UpdateDateFromService;
import com.suncode.plugin.drosed.service.SoapParameteres;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.exception.JDEException;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.BusinessServiceException;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.SuncodeExportPurchaseOrdersManager2;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.SuncodeExportPurchaseOrdersManager2Service;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.SuncodeExportPurchaseOrdersOrderVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.SuncodeExportPurchaseOrdersVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager2.SuncodeExportPurchaseOrdersVoOutput;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import jakarta.xml.ws.BindingProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class PurchaseOrdersManager2Task {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrdersManager2Task.class);
    static final String SERVICE_NAME = "SuncodeExportPurchaseOrdersManager2";
    @Autowired
    private UpdateDateFromService updatedDateService;
    @Autowired
    private PurchaseOrdersOrder2Service purchaseOrdersOrder2Service;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("drosed.purchaseordersmanager2")).name("SuncodeExportPurchaseOrders2Manager")).create();
    }

    public void execute(org.apache.log4j.Logger taskLog) throws Exception {
        try {
            taskLog.debug((Object)"****** START SuncodeExportPurchaseOrdersManager2*********");
            Date lastDate = this.updatedDateService.getDate(SERVICE_NAME);
            taskLog.debug((Object)("Last date:\t" + String.valueOf(lastDate)));
            Date newDate = new Date();
            SuncodeExportPurchaseOrdersVoOutput response = this.getJDEDate(lastDate, taskLog);
            taskLog.debug((Object)"Otrzymanie danych");
            if (response == null) {
                taskLog.debug((Object)"NO DATA");
                this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
                return;
            }
            List<E1XeltoMessage> e1Messages = response.getE1Messages();
            List<SuncodeExportPurchaseOrdersOrderVoOutput> orders = response.getOrders();
            int responseStatus = response.getResponseStatus();
            taskLog.debug((Object)("ResponseStatus: " + responseStatus));
            if (!e1Messages.isEmpty()) {
                taskLog.debug((Object)"E1MESSEGES");
                taskLog.debug((Object)"FileName\tMessage\tMessageCode\tRequestMappingIndex");
                for (E1XeltoMessage e1MSG : e1Messages) {
                    taskLog.debug((Object)(e1MSG.getFileName() + "\t" + e1MSG.getMessage() + "\t" + e1MSG.getMessageCode() + "\t" + e1MSG.getRequestMappingIndex()));
                }
                throw new Exception("E1MESSEGES Error");
            }
            taskLog.debug((Object)("Finded:\t" + orders.size()));
            taskLog.debug((Object)"Save to database table:\tpm_cust_jde_purchase_orders_order");
            this.purchaseOrdersOrder2Service.saveAll(orders);
            this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
        }
        catch (Exception e) {
            taskLog.debug((Object)(e.getClass().getSimpleName() + "\t" + e.getMessage()));
            taskLog.debug((Object)"ERROR");
            throw e;
        }
    }

    private SuncodeExportPurchaseOrdersVoOutput getJDEDate(Date lastDate, org.apache.log4j.Logger taskLog) throws MalformedURLException, DatatypeConfigurationException, BusinessServiceException_Exception, JDEException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            URL wsdlUrl = new URL(SoapParameteres.getWsdlHost() + "SuncodeExportPurchaseOrdersManager2?wsdl");
            taskLog.debug((Object)("URL: " + String.valueOf(wsdlUrl)));
            SuncodeExportPurchaseOrdersManager2Service sePurchaseOrdersManagerService = new SuncodeExportPurchaseOrdersManager2Service(wsdlUrl);
            sePurchaseOrdersManagerService.setHandlerResolver(SOAPHeaderHandler.getHendlerResolver());
            SuncodeExportPurchaseOrdersManager2 port = sePurchaseOrdersManagerService.getSuncodeExportPurchaseOrdersManager2Port();
            int timeout = 240000;
            taskLog.debug((Object)("Ustawienie timeout: " + timeout + " ms"));
            ((BindingProvider)port).getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", timeout);
            ((BindingProvider)port).getRequestContext().put("com.sun.xml.internal.ws.request.timeout", timeout);
            SuncodeExportPurchaseOrdersVoInput suncodeExportPurchaseOrders = new SuncodeExportPurchaseOrdersVoInput();
            suncodeExportPurchaseOrders.setUpdateDateFrom(Functions.toXMLGregorianCalendar(new LocalDateTime(lastDate.getTime())));
            taskLog.debug((Object)("Dane wej\u015bciowe:" + String.valueOf(suncodeExportPurchaseOrders)));
            taskLog.debug((Object)"Odpytanie web serwisu");
            SuncodeExportPurchaseOrdersVoOutput suncodeExportPurchaseOrdersVoOutput = port.suncodeExportPurchaseOrders2(suncodeExportPurchaseOrders);
            return suncodeExportPurchaseOrdersVoOutput;
        }
        catch (BusinessServiceException_Exception e) {
            taskLog.debug((Object)("Error: " + e.getMessage()));
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            StringBuilder sb = new StringBuilder();
            BusinessServiceException info = e.getFaultInfo();
            if (info != null) {
                String message = info.getMessage();
                String requestID = info.getRequestID();
                sb.append("message: ").append(message).append(", ");
                sb.append("requestID: ").append(requestID).append("\n");
                log.debug(sb.toString());
            } else {
                sb.append(e.getMessage());
            }
            throw new JDEException(sb.toString());
        }
        catch (Exception e) {
            log.error("Error: " + e.getMessage(), (Throwable)e);
            taskLog.debug((Object)("Error: " + e.getMessage()));
            throw new JDEException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

