/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.scheduledtask;

import com.suncode.plugin.drosed.db.service.UpdateDateFromService;
import com.suncode.plugin.drosed.service.SoapParameteres;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookAddressVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookManager;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookVoOutput;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class DrosedConTest {
    static final String SERVICE_NAME = "TestSuncodeExportAddressBookManager";
    @Autowired
    UpdateDateFromService updatedDateService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("drosed.test")).name("Drosed TEST SuncodeExportAddressBookManager")).description("Do testowania")).create();
    }

    public void execute(Logger taskLog) throws Exception {
        taskLog.debug((Object)"************ Start DrosedConTest ************");
        Date lastDate = this.updatedDateService.getDate(SERVICE_NAME);
        URL wsdlLocation = new URL(SoapParameteres.getWsdlHost() + "SuncodeExportAddressBookManager?wsdl");
        SuncodeExportAddressBookManagerService bookManagerService = new SuncodeExportAddressBookManagerService(wsdlLocation);
        taskLog.debug((Object)("Connection to :" + SoapParameteres.getWsdlHost() + "DV910/SuncodeExportAddressBookManager?wsdl"));
        bookManagerService.setHandlerResolver(SOAPHeaderHandler.getHendlerResolver());
        taskLog.debug((Object)bookManagerService.getWSDLDocumentLocation());
        SuncodeExportAddressBookManager port = bookManagerService.getSuncodeExportAddressBookManagerPort();
        SuncodeExportAddressBookVoInput suncodeExportAddressBook = new SuncodeExportAddressBookVoInput();
        LocalDateTime localDateTime = new LocalDateTime(lastDate.getTime());
        try {
            XMLGregorianCalendar date = Functions.toXMLGregorianCalendar(localDateTime);
            suncodeExportAddressBook.setUpdateDateFrom(date);
            SuncodeExportAddressBookVoOutput response = port.suncodeExportAddressBook(suncodeExportAddressBook);
            List<SuncodeExportAddressBookAddressVoOutput> addresses = response.getAddresses();
            List<E1XeltoMessage> e1Messages = response.getE1Messages();
            taskLog.debug((Object)("ResponseStatus: " + response.getResponseStatus()));
            if (!e1Messages.isEmpty()) {
                taskLog.debug((Object)"E1MESSEGES");
                taskLog.debug((Object)"FileName\tMessage\tMessageCode\tRequestMappingIndex");
                for (E1XeltoMessage e1MSG : e1Messages) {
                    taskLog.debug((Object)(e1MSG.getFileName() + "\t" + e1MSG.getMessage() + "\t" + e1MSG.getMessageCode() + "\t" + e1MSG.getRequestMappingIndex()));
                }
                taskLog.debug((Object)"************ End Failure ************");
                throw new Exception("E1MESSEGES Error");
            }
            for (SuncodeExportAddressBookAddressVoOutput suncodeExportAddressBookAddressVoOutput : addresses) {
                StringBuilder sb = new StringBuilder("\nAdress\n");
                sb.append("\n\t").append(suncodeExportAddressBookAddressVoOutput.getAddress());
                sb.append("\n\t").append(suncodeExportAddressBookAddressVoOutput.getAddressNumber());
                sb.append("\n\t").append(suncodeExportAddressBookAddressVoOutput.getCity());
                sb.append("\n\t").append(suncodeExportAddressBookAddressVoOutput.getNameMailing());
                sb.append("\n\t").append(suncodeExportAddressBookAddressVoOutput.getTaxId());
                sb.append("\n\t").append(suncodeExportAddressBookAddressVoOutput.getZipCodePostal());
                sb.append("\n");
                taskLog.debug((Object)sb.toString());
            }
            taskLog.debug((Object)"************ End success ************");
        }
        catch (BusinessServiceException_Exception bse) {
            taskLog.debug((Object)"************ End Failure ************");
            String msg = bse.getFaultInfo().getMessage();
            String rId = bse.getFaultInfo().getRequestID();
            taskLog.debug((Object)msg);
            taskLog.debug((Object)rId);
            taskLog.debug((Object)"\nSTACK TRACE\n");
            throw new Exception(rId + ":\t" + msg);
        }
    }
}

