/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.scheduledtask;

import com.suncode.plugin.drosed.db.service.BusinessUnitsManagerService;
import com.suncode.plugin.drosed.db.service.UpdateDateFromService;
import com.suncode.plugin.drosed.service.SoapParameteres;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.exception.JDEException;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.BusinessServiceException;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.SuncodeExportBusinessUnitsElementVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.SuncodeExportBusinessUnitsManager;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.SuncodeExportBusinessUnitsManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.SuncodeExportBusinessUnitsVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.SuncodeExportBusinessUnitsVoOutput;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class BusinessUnitsManagerTask {
    private static final Logger log = LoggerFactory.getLogger(BusinessUnitsManagerTask.class);
    static final String SERVICE_NAME = "SuncodeExportBusinessUnitsManager";
    @Autowired
    UpdateDateFromService updatedDateService;
    @Autowired
    BusinessUnitsManagerService businessUnitsManagerService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("drosed.businessunitsmanager")).name(SERVICE_NAME)).create();
    }

    public void execute(org.apache.log4j.Logger taskLog) throws Exception {
        try {
            taskLog.debug((Object)"****** START SuncodeExportBusinessUnitsManager*********");
            Date lastDate = this.updatedDateService.getDate(SERVICE_NAME);
            taskLog.debug((Object)("Last date:\t" + String.valueOf(lastDate)));
            Date newDate = new Date();
            SuncodeExportBusinessUnitsVoOutput response = this.getJDEDate(lastDate);
            if (response == null) {
                taskLog.debug((Object)"NO DATA");
                this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
                return;
            }
            taskLog.debug((Object)"Finded Data");
            List<E1XeltoMessage> e1Messages = response.getE1Messages();
            List<SuncodeExportBusinessUnitsElementVoOutput> items = response.getItems();
            int responseStatus = response.getResponseStatus();
            taskLog.debug((Object)("ResponseStatus: " + responseStatus));
            if (!e1Messages.isEmpty()) {
                taskLog.debug((Object)"E1MESSEGES");
                taskLog.debug((Object)"FileName\tMessage\tMessageCode\tRequestMappingIndex");
                for (E1XeltoMessage e1MSG : e1Messages) {
                    taskLog.debug((Object)(e1MSG.getFileName() + "\t" + e1MSG.getMessage() + "\t" + e1MSG.getMessageCode() + "\t" + e1MSG.getRequestMappingIndex()));
                }
                throw new Exception("E1MESSEGES Error");
            }
            taskLog.debug((Object)("Finded:\t" + items.size()));
            taskLog.debug((Object)"Save to database table:\tpm_cust_jde_business_units");
            this.businessUnitsManagerService.saveAll(items);
            this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
        }
        catch (Exception e) {
            taskLog.debug((Object)(e.getClass().getSimpleName() + "\t" + e.getMessage()));
            taskLog.debug((Object)"ERROR");
            throw e;
        }
    }

    private SuncodeExportBusinessUnitsVoOutput getJDEDate(Date lastDate) throws MalformedURLException, DatatypeConfigurationException, BusinessServiceException_Exception, JDEException {
        URL wsdlUrl = new URL(SoapParameteres.getWsdlHost() + "SuncodeExportBusinessUnitsManager?wsdl");
        log.debug("Set wsdlUrl:\t " + String.valueOf(wsdlUrl));
        SuncodeExportBusinessUnitsManagerService service = new SuncodeExportBusinessUnitsManagerService(wsdlUrl);
        log.debug("create service");
        service.setHandlerResolver(SOAPHeaderHandler.getHendlerResolver());
        SuncodeExportBusinessUnitsManager port = service.getSuncodeExportBusinessUnitsManagerPort();
        SuncodeExportBusinessUnitsVoInput request = new SuncodeExportBusinessUnitsVoInput();
        request.setUpdateDateFrom(Functions.toXMLGregorianCalendar(new LocalDateTime(lastDate.getTime())));
        try {
            SuncodeExportBusinessUnitsVoOutput response = port.suncodeExportBusinessUnits(request);
            return response;
        }
        catch (BusinessServiceException_Exception e) {
            StringBuilder sb = new StringBuilder();
            BusinessServiceException info = e.getFaultInfo();
            if (info != null) {
                String message = info.getMessage();
                String requestID = info.getRequestID();
                sb.append("message: ").append(message).append(", ");
                sb.append("requestID: ").append(requestID).append("\n");
                log.debug(sb.toString());
            } else {
                sb.append(e.getMessage());
            }
            throw new JDEException(sb.toString());
        }
        catch (Exception e) {
            throw new JDEException(e.getMessage());
        }
    }
}

