/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.scheduledtask;

import com.suncode.plugin.drosed.db.service.AccountsService;
import com.suncode.plugin.drosed.db.service.UpdateDateFromService;
import com.suncode.plugin.drosed.service.SoapParameteres;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.exception.JDEException;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.BusinessServiceException;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsElementVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsManager;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsVoOutput;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class AccountsManagerTask {
    private static final Logger log = LoggerFactory.getLogger(AccountsManagerTask.class);
    static final String SERVICE_NAME = "SuncodeExportAccountsManager";
    @Autowired
    UpdateDateFromService updatedDateService;
    @Autowired
    AccountsService accountsService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("drosed.accountsmanagertask")).name(SERVICE_NAME)).parameter().id("costCenter").name("costCenter").type((Type)Types.STRING).optional().create();
    }

    public void execute(@Param(value="costCenter") String costCenter, org.apache.log4j.Logger taskLog) throws Exception {
        try {
            taskLog.debug((Object)"****** START SuncodeExportAccountsManager*********");
            Date lastDate = this.updatedDateService.getDate(SERVICE_NAME);
            taskLog.debug((Object)("Last date:\t" + String.valueOf(lastDate)));
            Date newDate = new Date();
            SuncodeExportAccountsVoOutput response = this.getJDEDate(lastDate, costCenter);
            if (response == null) {
                taskLog.debug((Object)"NO DATA");
                this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
                return;
            }
            List<E1XeltoMessage> e1Messages = response.getE1Messages();
            List<SuncodeExportAccountsElementVoOutput> accounts = response.getAccounts();
            int responseStatus = response.getResponseStatus();
            taskLog.debug((Object)("ResponseStatus: " + responseStatus));
            if (!e1Messages.isEmpty()) {
                taskLog.debug((Object)"E1MESSEGES");
                taskLog.debug((Object)"FileName\tMessage\tMessageCode\tRequestMappingIndex");
                for (E1XeltoMessage e1MSG : e1Messages) {
                    taskLog.debug((Object)(e1MSG.getFileName() + "\t" + e1MSG.getMessage() + "\t" + e1MSG.getMessageCode() + "\t" + e1MSG.getRequestMappingIndex()));
                }
                throw new Exception("E1MESSEGES Error");
            }
            taskLog.debug((Object)("Finded:\t" + accounts.size()));
            Long newSaved = this.accountsService.saveAll(accounts);
            log.debug("Save " + newSaved + "new records");
            this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
        }
        catch (Exception e) {
            taskLog.error((Object)(e.getClass().getSimpleName() + "\t" + e.getMessage()), (Throwable)e);
            taskLog.error((Object)"ERROR");
            throw e;
        }
    }

    private SuncodeExportAccountsVoOutput getJDEDate(Date lastDate, String costCenter) throws MalformedURLException, DatatypeConfigurationException, BusinessServiceException_Exception, JDEException {
        URL wsdlUrl = new URL(SoapParameteres.getWsdlHost() + "SuncodeExportAccountsManager?wsdl");
        SuncodeExportAccountsManagerService service = new SuncodeExportAccountsManagerService(wsdlUrl);
        service.setHandlerResolver(SOAPHeaderHandler.getHendlerResolver());
        SuncodeExportAccountsManager port = service.getSuncodeExportAccountsManagerPort();
        SuncodeExportAccountsVoInput request = new SuncodeExportAccountsVoInput();
        request.setCostCenter(costCenter);
        request.setUpdateDateFrom(Functions.toXMLGregorianCalendar(new LocalDateTime(lastDate.getTime())));
        try {
            SuncodeExportAccountsVoOutput response = port.suncodeExportAccounts(request);
            return response;
        }
        catch (BusinessServiceException_Exception e) {
            StringBuilder sb = new StringBuilder();
            BusinessServiceException info = e.getFaultInfo();
            if (info != null) {
                String message = info.getMessage();
                String requestID = info.getRequestID();
                sb.append("message: ").append(message).append(", ");
                sb.append("requestID: ").append(requestID).append("\n");
                log.debug(sb.toString());
            } else {
                sb.append(e.getMessage());
            }
            throw new JDEException(sb.toString());
        }
        catch (Exception e) {
            throw new JDEException(e.getMessage());
        }
    }
}

