/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.PurchaseOrdersOrderDao;
import com.suncode.plugin.drosed.db.entity.PurchaseOrdersOrder;
import com.suncode.plugin.drosed.db.service.PurchaseOrdersOrderService;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.suncode.export.purchaseordersmanager.SuncodeExportPurchaseOrdersOrderVoOutput;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PurchaseOrdersOrderServiceImpl
extends EditableServiceImpl<PurchaseOrdersOrder, Long, PurchaseOrdersOrderDao>
implements PurchaseOrdersOrderService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrdersOrderServiceImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(PurchaseOrdersOrderDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<SuncodeExportPurchaseOrdersOrderVoOutput> dates) {
        Long index = 0L;
        for (SuncodeExportPurchaseOrdersOrderVoOutput suncodeExportPurchaseOrdersOrderVoOutput : dates) {
            PurchaseOrdersOrder entity = this.findOne(suncodeExportPurchaseOrdersOrderVoOutput.getOrderNumber());
            if (entity != null) {
                entity.setAmountOpen(suncodeExportPurchaseOrdersOrderVoOutput.getAmountOpen().doubleValue());
                entity.setAmountReceived(suncodeExportPurchaseOrdersOrderVoOutput.getAmountReceived().doubleValue());
                entity.setDateTransaction(Functions.convertDate(suncodeExportPurchaseOrdersOrderVoOutput.getDateTransaction()));
                entity.setObjectAccount(suncodeExportPurchaseOrdersOrderVoOutput.getObjectAccount());
                entity.setOrderCompany(suncodeExportPurchaseOrdersOrderVoOutput.getOrderCompany());
                entity.setOrderSuffix(suncodeExportPurchaseOrdersOrderVoOutput.getOrderSuffix());
                entity.setOrderType(suncodeExportPurchaseOrdersOrderVoOutput.getOrderType());
                entity.setPurchasingCostCenter(suncodeExportPurchaseOrdersOrderVoOutput.getPurchasingCostCenter());
                entity.setSubledger(suncodeExportPurchaseOrdersOrderVoOutput.getSubledger());
                entity.setSubledgerType(suncodeExportPurchaseOrdersOrderVoOutput.getSubledgerType());
                entity.setSubsidiary(suncodeExportPurchaseOrdersOrderVoOutput.getSubsidiary());
            } else {
                entity = this.buildEntity(suncodeExportPurchaseOrdersOrderVoOutput);
            }
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)entity);
            Long l = index;
            index = index + 1L;
        }
        log.debug("Save or Update " + index + " records");
    }

    private PurchaseOrdersOrder findOne(Integer orderNumber) {
        DetachedCriteria dc = DetachedCriteria.forClass(PurchaseOrdersOrder.class);
        dc.add((Criterion)Restrictions.eq((String)"orderNumber", (Object)orderNumber));
        return (PurchaseOrdersOrder)((PurchaseOrdersOrderDao)this.dao).findOne(dc);
    }

    private PurchaseOrdersOrder buildEntity(SuncodeExportPurchaseOrdersOrderVoOutput suncodeExportPurchaseOrdersOrderVoOutput) {
        PurchaseOrdersOrder result = new PurchaseOrdersOrder();
        result.setAmountOpen(suncodeExportPurchaseOrdersOrderVoOutput.getAmountOpen().doubleValue());
        result.setAmountReceived(suncodeExportPurchaseOrdersOrderVoOutput.getAmountReceived().doubleValue());
        result.setDateTransaction(Functions.convertDate(suncodeExportPurchaseOrdersOrderVoOutput.getDateTransaction()));
        result.setObjectAccount(suncodeExportPurchaseOrdersOrderVoOutput.getObjectAccount());
        result.setOrderCompany(suncodeExportPurchaseOrdersOrderVoOutput.getOrderCompany());
        result.setOrderNumber(suncodeExportPurchaseOrdersOrderVoOutput.getOrderNumber());
        result.setOrderSuffix(suncodeExportPurchaseOrdersOrderVoOutput.getOrderSuffix());
        result.setOrderType(suncodeExportPurchaseOrdersOrderVoOutput.getOrderType());
        result.setPurchasingCostCenter(suncodeExportPurchaseOrdersOrderVoOutput.getPurchasingCostCenter());
        result.setSubledger(suncodeExportPurchaseOrdersOrderVoOutput.getSubledger());
        result.setSubledgerType(suncodeExportPurchaseOrdersOrderVoOutput.getSubledgerType());
        result.setSubsidiary(suncodeExportPurchaseOrdersOrderVoOutput.getSubsidiary());
        return result;
    }
}

