/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.CompaniesDao;
import com.suncode.plugin.drosed.db.entity.Companies;
import com.suncode.plugin.drosed.db.service.CompaniesManagerService;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.SuncodeExportCompaniesElementVoOutput;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CompaniesManagerServiceImpl
extends EditableServiceImpl<Companies, Long, CompaniesDao>
implements CompaniesManagerService {
    private static final Logger log = LoggerFactory.getLogger(CompaniesManagerServiceImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(CompaniesDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<SuncodeExportCompaniesElementVoOutput> companies) {
        Long indexSave = 0L;
        Long indexUpdate = 0L;
        for (SuncodeExportCompaniesElementVoOutput company : companies) {
            Long l;
            Companies entity = this.buildEntity(company);
            Companies finded = this.findOne(entity);
            if (finded == null) {
                log.debug("Save \n" + entity.toString());
                this.sessionFactory.getCurrentSession().save((Object)entity);
                l = indexSave;
                indexSave = indexSave + 1L;
                continue;
            }
            finded.setAPFiscalYearBeginsDate(entity.getAPFiscalYearBeginsDate());
            finded.setAPperiodNumber(entity.getAPperiodNumber());
            log.debug("Update \n" + finded.toString());
            this.sessionFactory.getCurrentSession().update((Object)finded);
            l = indexUpdate;
            indexUpdate = indexUpdate + 1L;
        }
        log.debug("Saved " + indexSave + " records");
        log.debug("Updated " + indexUpdate + " records");
    }

    private Companies findOne(Companies entity) {
        DetachedCriteria dc = DetachedCriteria.forClass(Companies.class);
        dc.add((Criterion)Restrictions.eq((String)"company", (Object)entity.getCompany()));
        return (Companies)((CompaniesDao)this.dao).findOne(dc);
    }

    private Companies buildEntity(SuncodeExportCompaniesElementVoOutput company) {
        Companies result = new Companies();
        result.setAPFiscalYearBeginsDate(Functions.convertDate(company.getAPFiscalYearBeginsDate()));
        result.setAPperiodNumber(company.getAPperiodNumber());
        result.setCompany(company.getCompany());
        return result;
    }
}

