/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.BusinessUnitsDao;
import com.suncode.plugin.drosed.db.entity.BusinessUnits;
import com.suncode.plugin.drosed.db.service.BusinessUnitsManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.businessunitsmanager.SuncodeExportBusinessUnitsElementVoOutput;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BusinessUnitsManagerServiceImpl
extends EditableServiceImpl<BusinessUnits, Long, BusinessUnitsDao>
implements BusinessUnitsManagerService {
    private static final Logger log = LoggerFactory.getLogger(BusinessUnitsManagerServiceImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(BusinessUnitsDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<SuncodeExportBusinessUnitsElementVoOutput> items) {
        Long index = 0L;
        for (SuncodeExportBusinessUnitsElementVoOutput item : items) {
            BusinessUnits entity = this.buildEntity(item);
            if (this.findOne(entity) != null) continue;
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)entity);
            Long l = index;
            index = index + 1L;
        }
        log.debug("Save " + index + " records");
    }

    private BusinessUnits findOne(BusinessUnits entity) {
        DetachedCriteria dc = DetachedCriteria.forClass(BusinessUnits.class);
        dc.add((Criterion)Restrictions.eq((String)"company", (Object)entity.getCompany()));
        dc.add((Criterion)Restrictions.eq((String)"costCenter", (Object)entity.getCostCenter()));
        dc.add((Criterion)Restrictions.eq((String)"description", (Object)entity.getDescription()));
        return (BusinessUnits)((BusinessUnitsDao)this.dao).findOne(dc);
    }

    private BusinessUnits buildEntity(SuncodeExportBusinessUnitsElementVoOutput item) {
        BusinessUnits bUnits = new BusinessUnits();
        bUnits.setCompany(item.getCompany());
        bUnits.setCostCenter(item.getCostCenter());
        bUnits.setDescription(item.getDescription());
        return bUnits;
    }
}

