/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.AddressBookDao;
import com.suncode.plugin.drosed.db.entity.AddressBook;
import com.suncode.plugin.drosed.db.service.AddressBookManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.addressbookmanager.SuncodeExportAddressBookAddressVoOutput;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AddressBookManagerServiceImpl
extends EditableServiceImpl<AddressBook, Long, AddressBookDao>
implements AddressBookManagerService {
    private static final Logger log = LoggerFactory.getLogger(AddressBookManagerServiceImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(AddressBookDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<SuncodeExportAddressBookAddressVoOutput> addresses) {
        Long index = 0L;
        for (SuncodeExportAddressBookAddressVoOutput address : addresses) {
            AddressBook entity = this.findOne(address.getAddressNumber());
            if (entity != null) {
                entity.setAddress(address.getAddress());
                entity.setCity(address.getCity());
                entity.setNameMailing(address.getNameMailing());
                entity.setTaxId(address.getTaxId());
                entity.setZipCodePostal(address.getZipCodePostal());
            } else {
                entity = this.buildEntity(address);
            }
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)entity);
            Long l = index;
            index = index + 1L;
        }
        log.debug("Save or Update " + index + " records");
    }

    private AddressBook findOne(Integer addressNumber) {
        DetachedCriteria dc = DetachedCriteria.forClass(AddressBook.class);
        dc.add((Criterion)Restrictions.eq((String)"addressNumber", (Object)addressNumber));
        return (AddressBook)((AddressBookDao)this.dao).findOne(dc);
    }

    private AddressBook buildEntity(SuncodeExportAddressBookAddressVoOutput adress) {
        AddressBook result = new AddressBook();
        result.setAddress(adress.getAddress());
        result.setAddressNumber(adress.getAddressNumber());
        result.setCity(adress.getCity());
        result.setNameMailing(adress.getNameMailing());
        result.setTaxId(adress.getTaxId());
        result.setZipCodePostal(adress.getZipCodePostal());
        return result;
    }
}

