/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.AccountsDao;
import com.suncode.plugin.drosed.db.entity.Accounts;
import com.suncode.plugin.drosed.db.service.AccountsService;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsElementVoOutput;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AccountsServiceImpl
extends EditableServiceImpl<Accounts, Long, AccountsDao>
implements AccountsService {
    private static final Logger log = LoggerFactory.getLogger(AccountsServiceImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(AccountsDao dao) {
        this.dao = dao;
    }

    private Accounts buildEntity(SuncodeExportAccountsElementVoOutput account) {
        Accounts result = new Accounts();
        result.setCompany(account.getCompany());
        result.setCostCenter(account.getCostCenter());
        result.setDescription(account.getDescription());
        result.setObjectAccount(account.getObjectAccount());
        result.setSubsidiary(account.getSubsidiary());
        result.setId(0L);
        return result;
    }

    @Override
    public Long saveAll(List<SuncodeExportAccountsElementVoOutput> accounts) {
        Long index = 0L;
        for (SuncodeExportAccountsElementVoOutput account : accounts) {
            Accounts entity = this.buildEntity(account);
            if (account == null) {
                log.debug("accuont is null");
            } else {
                log.debug("accuont is not null");
            }
            entity = this.findOne(entity);
            if (entity == null) {
                entity = this.buildEntity(account);
                entity.setId(this.maxId() + 1L);
            } else {
                entity.setDescription(account.getDescription());
            }
            Long l = index;
            index = index + 1L;
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)entity);
        }
        log.debug("Save " + index + " records");
        return index;
    }

    private Accounts findOne(Accounts account) {
        DetachedCriteria dc = DetachedCriteria.forClass(Accounts.class);
        dc.add((Criterion)Restrictions.eq((String)"company", (Object)account.getCompany()));
        dc.add((Criterion)Restrictions.eq((String)"costCenter", (Object)account.getCostCenter()));
        dc.add((Criterion)Restrictions.eq((String)"objectAccount", (Object)account.getObjectAccount()));
        dc.add((Criterion)Restrictions.eq((String)"subsidiary", (Object)account.getSubsidiary()));
        return (Accounts)((AccountsDao)this.dao).findOne(dc);
    }

    private Long maxId() {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(Accounts.class).setProjection((Projection)Projections.max((String)"id"));
        Long maxId = (Long)criteria.uniqueResult();
        return maxId == null ? 0L : maxId;
    }
}

