/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.webservice.hendler;

import com.suncode.plugin.drosed.service.SoapParameteres;
import com.suncode.plugin.drosed.service.SystemParametersKey;
import com.suncode.plugin.drosed.webservice.hendler.SoapXmlLog;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SOAPHeaderHandler
implements SOAPHandler<SOAPMessageContext> {
    private final String username;
    private final String password;

    public SOAPHeaderHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            try {
                SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
                SOAPHeader header = envelope.getHeader();
                if (header == null) {
                    header = envelope.addHeader();
                }
                SOAPElement security = header.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                SOAPElement userToken = security.addChildElement("UsernameToken", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                userToken.addChildElement("Username", "wsse").addTextNode(this.username);
                SOAPElement passwordElm = userToken.addChildElement("Password", "wsse");
                passwordElm.addAttribute(new QName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                passwordElm.addTextNode(this.password);
            }
            catch (Exception e) {
                new RuntimeException(e);
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return new TreeSet<QName>();
    }

    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    public void close(MessageContext context) {
    }

    public static HandlerResolver getHendlerResolver() {
        return new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new SOAPHeaderHandler(SoapParameteres.getUsername(), SoapParameteres.getPassword()));
                if (SystemProperties.getBoolean((String)SystemParametersKey.XML_DEBUG.getName()).booleanValue()) {
                    handlerList.add((Handler)new SoapXmlLog("DEBUG SOAP XML"));
                }
                return handlerList;
            }
        };
    }
}

