/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.test;

import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.exception.JDEException;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.hendler.SoapXmlLog;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.BusinessServiceException;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsElementVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsManager;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsVoOutput;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAccountManager {
    private static final Logger log = LoggerFactory.getLogger(TestAccountManager.class);

    public static void main(String[] args) throws IOException, Exception {
        final HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        HostnameVerifier localhostAcceptedHostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                if (hostname.equals("localhost")) {
                    return true;
                }
                return defaultHostnameVerifier.verify(hostname, sslSession);
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(localhostAcceptedHostnameVerifier);
        LocalDateTime localDateTime = new LocalDateTime((Object)"2021-03-17");
        XMLGregorianCalendar date = Functions.toXMLGregorianCalendar(localDateTime);
        SuncodeExportAccountsVoOutput response = TestAccountManager.getJDEDate(date);
        if (response == null) {
            return;
        }
        List<E1XeltoMessage> e1Messages = response.getE1Messages();
        for (E1XeltoMessage e1XeltoMessage : e1Messages) {
            log.debug(e1XeltoMessage.getMessage() + "\t" + e1XeltoMessage.getFileName());
        }
        List<SuncodeExportAccountsElementVoOutput> accounts = response.getAccounts();
        int responseStatus = response.getResponseStatus();
        log.debug("" + responseStatus);
        log.debug("Size:\t" + accounts.size());
        for (SuncodeExportAccountsElementVoOutput voOutput : accounts) {
            log.debug(voOutput.getCompany() + "\t" + voOutput.getCostCenter() + "\t" + voOutput.getDescription() + "\t" + voOutput.getObjectAccount() + "\t" + voOutput.getSubsidiary());
        }
    }

    private static SuncodeExportAccountsVoOutput getJDEDate(XMLGregorianCalendar date) throws Exception {
        String SERVICE_NAME = "SuncodeExportAccountsManager";
        URL wsdlUrl = new URL("https://localhost:8285/PY910/SuncodeExportAccountsManager?wsdl");
        SuncodeExportAccountsManagerService service = new SuncodeExportAccountsManagerService(wsdlUrl);
        service.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new SOAPHeaderHandler("BSSVSUNCO2", "l#jsDg8qL"));
                handlerList.add((Handler)new SoapXmlLog("DEBUG SOAP XML"));
                return handlerList;
            }
        });
        SuncodeExportAccountsManager port = service.getSuncodeExportAccountsManagerPort();
        SuncodeExportAccountsVoInput voInput = new SuncodeExportAccountsVoInput();
        voInput.setUpdateDateFrom(date);
        voInput.setCostCenter("");
        SuncodeExportAccountsVoOutput response = null;
        try {
            response = port.suncodeExportAccounts(voInput);
        }
        catch (BusinessServiceException_Exception bSE) {
            BusinessServiceException info = bSE.getFaultInfo();
            String infoMSG = info.getMessage();
            String infoRequest = info.getRequestID();
            String msg = bSE.getMessage();
            log.error("InfoMSG: " + infoMSG + " RequestID: " + infoRequest + "ErrorMSG: " + msg, (Throwable)bSE);
        }
        catch (Exception e) {
            throw new JDEException(e.getMessage(), e);
        }
        return response;
    }
}

