/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.scheduledtask;

import com.suncode.plugin.drosed.db.service.CompaniesManagerService;
import com.suncode.plugin.drosed.db.service.UpdateDateFromService;
import com.suncode.plugin.drosed.service.SoapParameteres;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.exception.JDEException;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.BusinessServiceException;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.SuncodeExportCompaniesElementVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.SuncodeExportCompaniesManager;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.SuncodeExportCompaniesManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.SuncodeExportCompaniesVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.companiesmanager.SuncodeExportCompaniesVoOutput;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class CompaniesManagerTask {
    private static final Logger log = LoggerFactory.getLogger(CompaniesManagerTask.class);
    static final String SERVICE_NAME = "SuncodeExportCompaniesManager";
    @Autowired
    UpdateDateFromService updatedDateService;
    @Autowired
    CompaniesManagerService companiesManagerService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("drosed.companiesmanager")).name(SERVICE_NAME)).create();
    }

    public void execute(org.apache.log4j.Logger taskLog) throws Exception {
        try {
            taskLog.debug((Object)"****** START SuncodeExportCompaniesManager*********");
            Date lastDate = this.updatedDateService.getDate(SERVICE_NAME);
            taskLog.debug((Object)("Last date:\t" + lastDate));
            Date newDate = new Date();
            SuncodeExportCompaniesVoOutput response = this.getJDEDate(lastDate);
            if (response == null) {
                taskLog.debug((Object)"NO DATA");
                this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
                return;
            }
            List<E1XeltoMessage> e1Messages = response.getE1Messages();
            List<SuncodeExportCompaniesElementVoOutput> companies = response.getCompanies();
            int responseStatus = response.getResponseStatus();
            taskLog.debug((Object)("ResponseStatus: " + responseStatus));
            if (!e1Messages.isEmpty()) {
                taskLog.debug((Object)"E1MESSEGES");
                taskLog.debug((Object)"FileName\tMessage\tMessageCode\tRequestMappingIndex");
                for (E1XeltoMessage e1MSG : e1Messages) {
                    taskLog.debug((Object)(e1MSG.getFileName() + "\t" + e1MSG.getMessage() + "\t" + e1MSG.getMessageCode() + "\t" + e1MSG.getRequestMappingIndex()));
                }
                throw new Exception("E1MESSEGES Error");
            }
            taskLog.debug((Object)("Finded:\t" + companies.size()));
            taskLog.debug((Object)"Save to database table:\tpm_cust_jde_companies");
            this.companiesManagerService.saveAll(companies);
            this.updatedDateService.saveOrUpdate(SERVICE_NAME, newDate);
        }
        catch (Exception e) {
            taskLog.debug((Object)(e.getClass().getSimpleName() + "\t" + e.getMessage()));
            taskLog.debug((Object)"ERROR");
            throw e;
        }
    }

    private SuncodeExportCompaniesVoOutput getJDEDate(Date lastDate) throws MalformedURLException, DatatypeConfigurationException, BusinessServiceException_Exception, JDEException {
        URL wsdlUrl = new URL(SoapParameteres.getWsdlHost() + "SuncodeExportCompaniesManager?wsdl");
        SuncodeExportCompaniesManagerService service = new SuncodeExportCompaniesManagerService(wsdlUrl);
        service.setHandlerResolver(SOAPHeaderHandler.getHendlerResolver());
        SuncodeExportCompaniesManager port = service.getSuncodeExportCompaniesManagerPort();
        SuncodeExportCompaniesVoInput request = new SuncodeExportCompaniesVoInput();
        request.setUpdateDateFrom(Functions.toXMLGregorianCalendar(new LocalDateTime(lastDate.getTime())));
        try {
            SuncodeExportCompaniesVoOutput response = port.suncodeExportCompanies(request);
            return response;
        }
        catch (BusinessServiceException_Exception e) {
            StringBuilder sb = new StringBuilder();
            BusinessServiceException info = e.getFaultInfo();
            if (info != null) {
                String message = info.getMessage();
                String requestID = info.getRequestID();
                sb.append("message: ").append(message).append(", ");
                sb.append("requestID: ").append(requestID).append("\n");
                log.debug(sb.toString());
            } else {
                sb.append(e.getMessage());
            }
            throw new JDEException(sb.toString());
        }
        catch (Exception e) {
            throw new JDEException(e.getMessage());
        }
    }
}

