/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.scheduledtask;

import com.suncode.plugin.drosed.db.service.AccountsService;
import com.suncode.plugin.drosed.db.service.UpdateDateFromService;
import com.suncode.plugin.drosed.exception.CancelTaskException;
import com.suncode.plugin.drosed.service.SoapParameteres;
import com.suncode.plugin.drosed.tools.Functions;
import com.suncode.plugin.drosed.webservice.exception.JDEException;
import com.suncode.plugin.drosed.webservice.hendler.SOAPHeaderHandler;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.BusinessServiceException;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.BusinessServiceException_Exception;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.E1XeltoMessage;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsElementVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsManager;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsVoInput;
import com.suncode.plugin.drosed.webservice.suncode.export.accountsmanager.SuncodeExportAccountsVoOutput;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class AccountsManagerLoadTask {
    private static final Logger log = LoggerFactory.getLogger(AccountsManagerLoadTask.class);
    static final String SERVICE_NAME = "SuncodeExportAccountsManager";
    @Autowired
    UpdateDateFromService updatedDateService;
    @Autowired
    AccountsService accountsService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("drosed.accountsmanagertask.loadFromDate")).name("SuncodeExportAccountsManager \u0141adowanie danych od podanej daty")).description("Jednorazowo \u0142aduje dane od pdoanego dnia do daty aktualne zwi\u0119kszaj\u0105c licznik o ilo\u015bc dni")).cancelable().parameter().id("costCenter").name("costCenter").type((Type)Types.STRING).optional().create()).parameter().id("dateFrom").name("dateFrom").type((Type)Types.DATE).create()).parameter().id("incrementDay").name("incrementDay").type((Type)Types.INTEGER).create();
    }

    public String execute(@Param(value="costCenter") String costCenter, @Param(value="dateFrom") LocalDate dateFrom, @Param(value="incrementDay") Long incrementDay, org.apache.log4j.Logger taskLog, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancellation) throws Exception {
        try {
            Long countNewData = 0L;
            taskLog.debug((Object)("****** START " + scheduledTaskInfo.getName() + "*********"));
            LocalDate newDate = new LocalDate();
            while (!dateFrom.isAfter((ReadablePartial)newDate)) {
                taskLog.debug((Object)("Execute with date: " + dateFrom.toDate()));
                this.checkTaskCancellaion(cancellation);
                SuncodeExportAccountsVoOutput response = this.getJDEDate(dateFrom.toDate(), costCenter);
                if (response == null) {
                    taskLog.debug((Object)"NO DATA");
                    continue;
                }
                List<E1XeltoMessage> e1Messages = response.getE1Messages();
                List<SuncodeExportAccountsElementVoOutput> accounts = response.getAccounts();
                int responseStatus = response.getResponseStatus();
                log.debug("ResponseStatus: " + responseStatus);
                if (!e1Messages.isEmpty()) {
                    taskLog.debug((Object)"E1MESSEGES");
                    taskLog.debug((Object)"FileName\tMessage\tMessageCode\tRequestMappingIndex");
                    for (E1XeltoMessage e1MSG : e1Messages) {
                        taskLog.debug((Object)(e1MSG.getFileName() + "\t" + e1MSG.getMessage() + "\t" + e1MSG.getMessageCode() + "\t" + e1MSG.getRequestMappingIndex()));
                    }
                    throw new Exception("E1MESSEGES Error");
                }
                taskLog.debug((Object)("Finded:\t" + accounts.size()));
                Long newSaved = this.accountsService.saveAll(accounts);
                countNewData = countNewData + newSaved;
                taskLog.debug((Object)("Save " + newSaved + " new records for date: " + dateFrom.toDate()));
                dateFrom = dateFrom.plusDays(incrementDay.intValue());
            }
            String msg = "A total of " + countNewData + " new records have been added";
            taskLog.debug((Object)msg);
            taskLog.debug((Object)("****** ENDE " + scheduledTaskInfo.getName() + "*********"));
            return msg;
        }
        catch (Exception e) {
            taskLog.error((Object)(e.getClass().getSimpleName() + "\t" + e.getMessage()), (Throwable)e);
            taskLog.error((Object)"ERROR");
            taskLog.debug((Object)("****** ENDE " + scheduledTaskInfo.getName() + "*********"));
            throw e;
        }
    }

    private SuncodeExportAccountsVoOutput getJDEDate(Date lastDate, String costCenter) throws MalformedURLException, DatatypeConfigurationException, BusinessServiceException_Exception, JDEException {
        URL wsdlUrl = new URL(SoapParameteres.getWsdlHost() + "SuncodeExportAccountsManager?wsdl");
        SuncodeExportAccountsManagerService service = new SuncodeExportAccountsManagerService(wsdlUrl);
        service.setHandlerResolver(SOAPHeaderHandler.getHendlerResolver());
        SuncodeExportAccountsManager port = service.getSuncodeExportAccountsManagerPort();
        SuncodeExportAccountsVoInput request = new SuncodeExportAccountsVoInput();
        request.setCostCenter(costCenter);
        request.setUpdateDateFrom(Functions.toXMLGregorianCalendar(new LocalDateTime(lastDate.getTime())));
        try {
            SuncodeExportAccountsVoOutput response = port.suncodeExportAccounts(request);
            return response;
        }
        catch (BusinessServiceException_Exception e) {
            StringBuilder sb = new StringBuilder();
            BusinessServiceException info = e.getFaultInfo();
            if (info != null) {
                String message = info.getMessage();
                String requestID = info.getRequestID();
                sb.append("message: ").append(message).append(", ");
                sb.append("requestID: ").append(requestID).append("\n");
                log.debug(sb.toString());
            } else {
                sb.append(e.getMessage());
            }
            throw new JDEException(sb.toString());
        }
        catch (Exception e) {
            throw new JDEException(e.getMessage());
        }
    }

    private void checkTaskCancellaion(CancelationHandler cancellation) throws CancelTaskException {
        if (cancellation.isCanceled().booleanValue()) {
            throw new CancelTaskException("Cancelled by user");
        }
    }
}

