/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.UpdateDateFromDao;
import com.suncode.plugin.drosed.db.entity.UpdateDateFrom;
import com.suncode.plugin.drosed.db.service.UpdateDateFromService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpdateDateFromServiceImpl
implements UpdateDateFromService {
    private static final String FORMATDATE = "yyyyMMdd";
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private UpdateDateFromDao dao;

    @Override
    @Transactional
    public Date getDate(String serviceName) {
        serviceName = serviceName.toUpperCase();
        UpdateDateFrom row = this.getEntityByServiceName(serviceName);
        Date untilDate = new Date(0L);
        if (row == null) {
            this.saveOrUpdate(serviceName, untilDate);
        } else {
            java.sql.Date date = row.getDate();
            untilDate = new Date(date.getTime());
        }
        return untilDate;
    }

    @Override
    @Transactional
    public String getFormaterDate(String serviceName) {
        UpdateDateFrom row = this.getEntityByServiceName(serviceName.toUpperCase());
        Date untilDate = new Date(0L);
        if (row == null) {
            this.saveOrUpdate(serviceName, untilDate);
        } else {
            java.sql.Date date = row.getDate();
            untilDate = new Date(date.getTime());
        }
        SimpleDateFormat f = new SimpleDateFormat(FORMATDATE);
        return f.format(untilDate);
    }

    @Override
    @Transactional
    public void saveOrUpdate(String serviceName) {
        Date date = new Date();
        this.saveOrUpdate(serviceName, date);
    }

    private UpdateDateFrom getEntityByServiceName(String serviceName) {
        return (UpdateDateFrom)this.sessionFactory.getCurrentSession().byNaturalId(UpdateDateFrom.class).using("serviceName", (Object)serviceName).load();
    }

    @Override
    @Transactional
    public void saveOrUpdate(String serviceName, Date date) {
        serviceName = serviceName.toUpperCase();
        UpdateDateFrom entity = this.getEntityByServiceName(serviceName);
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        if (entity == null) {
            entity = new UpdateDateFrom();
            entity.setServiceName(serviceName);
            entity.setDate(sqlDate);
            this.dao.save(entity);
        } else {
            entity.setDate(sqlDate);
            this.dao.update(entity);
        }
    }
}

