/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.BankAccountsDao;
import com.suncode.plugin.drosed.db.entity.BankAccounts;
import com.suncode.plugin.drosed.db.service.BankAccountsManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.bankaccountsmanager.SuncodeExportBankAccountsAccountVoOutput;
import com.suncode.plugin.drosed.webservice.suncode.export.bankaccountsmanager.SuncodeExportBankAccountsAddressVoOutput;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BankAccountsManagerServiceImpl
extends EditableServiceImpl<BankAccounts, Long, BankAccountsDao>
implements BankAccountsManagerService {
    private static final Logger log = LoggerFactory.getLogger(BankAccountsManagerServiceImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(BankAccountsDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<SuncodeExportBankAccountsAddressVoOutput> addresses) {
        Long index = 0L;
        for (SuncodeExportBankAccountsAddressVoOutput address : addresses) {
            List<BankAccounts> entities = this.buildEntity(address);
            for (BankAccounts entity : entities) {
                if (this.findOne(entity) != null) continue;
                this.sessionFactory.getCurrentSession().saveOrUpdate((Object)entity);
                Long l = index;
                index = index + 1L;
            }
        }
        log.debug("Save " + index + " records");
    }

    private BankAccounts findOne(BankAccounts entity) {
        DetachedCriteria dc = DetachedCriteria.forClass(BankAccounts.class);
        dc.add((Criterion)Restrictions.eq((String)"addressNumber", (Object)entity.getAddressNumber()));
        dc.add((Criterion)Restrictions.eq((String)"bankAccountNumber", (Object)entity.getBankAccountNumber()));
        dc.add((Criterion)Restrictions.eq((String)"bankRecordType", (Object)entity.getBankRecordType()));
        dc.add((Criterion)Restrictions.eq((String)"company", (Object)entity.getCompany()));
        return (BankAccounts)((BankAccountsDao)this.dao).findOne(dc);
    }

    private List<BankAccounts> buildEntity(SuncodeExportBankAccountsAddressVoOutput adress) {
        Integer adressNumber = adress.getAddressNumber();
        ArrayList<BankAccounts> result = new ArrayList<BankAccounts>();
        List<SuncodeExportBankAccountsAccountVoOutput> accounts = adress.getAccounts();
        for (SuncodeExportBankAccountsAccountVoOutput account : accounts) {
            BankAccounts bankAccount = new BankAccounts();
            bankAccount.setAddressNumber(adressNumber);
            bankAccount.setBankAccountNumber(account.getBankAccountNumber());
            bankAccount.setBankRecordType(account.getBankRecordType());
            bankAccount.setCompany(account.getCompany());
            result.add(bankAccount);
        }
        return result;
    }
}

