/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drosed.db.service;

import com.suncode.plugin.drosed.db.dao.APInvoicesDao;
import com.suncode.plugin.drosed.db.entity.APInvoices;
import com.suncode.plugin.drosed.db.service.APInvoicesManagerService;
import com.suncode.plugin.drosed.webservice.suncode.export.apiinvoicesmanager.SuncodeExportAPInvoicesInvoiceVoOutput;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class APInvoicesManagerServiceImpl
extends EditableServiceImpl<APInvoices, Long, APInvoicesDao>
implements APInvoicesManagerService {
    private static final Logger log = LoggerFactory.getLogger(APInvoicesManagerServiceImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(APInvoicesDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<SuncodeExportAPInvoicesInvoiceVoOutput> apInvoices) {
        Long index = 0L;
        for (SuncodeExportAPInvoicesInvoiceVoOutput apInvoice : apInvoices) {
            APInvoices entity = this.buildEntity(apInvoice);
            if (this.findOne(entity) != null) continue;
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)entity);
            Long l = index;
            index = index + 1L;
        }
        log.debug("Save " + index + " records");
    }

    private APInvoices findOne(APInvoices entity) {
        DetachedCriteria dc = DetachedCriteria.forClass(APInvoices.class);
        dc.add((Criterion)Restrictions.eq((String)"addressNumber", (Object)entity.getAddressNumber()));
        dc.add((Criterion)Restrictions.eq((String)"documentCompany", (Object)entity.getDocumentCompany()));
        dc.add((Criterion)Restrictions.eq((String)"documentNumber", (Object)entity.getDocumentNumber()));
        dc.add((Criterion)Restrictions.eq((String)"vendorInvoiceNumber", (Object)entity.getVendorInvoiceNumber()));
        return (APInvoices)((APInvoicesDao)this.dao).findOne(dc);
    }

    private APInvoices buildEntity(SuncodeExportAPInvoicesInvoiceVoOutput apInvocie) {
        APInvoices result = new APInvoices();
        result.setAddressNumber(apInvocie.getAddressNumber());
        result.setDocumentNumber(apInvocie.getDocumentNumber());
        result.setDocumentCompany(apInvocie.getDocumentCompany());
        result.setDocumentType(apInvocie.getDocumentType());
        result.setVendorInvoiceNumber(apInvocie.getVendorInvoiceNumber());
        return result;
    }
}

