PWE.integrationComponent.registerFormAction("dnd-table", {
    apiVersion: 2,
    validateForm: function (api) {
        if (api.hasVariableArrayValue('variableId')) {
            api.showErrorMessage(DnDPlugin.t("action.draganddrop.mustBeNonArrayVariable"));
            api.markError("variableId");
            return false;
        }

        if (api.getVariableType("columnRender") !== "string[]") {
            api.showErrorMessage(DnD.t("action.draganddrop.msgVariableIsNotColumn"));
            api.markError("columnRender")
            return false;
        }

        if (api.getVariableType("columnFileId") !== "string[]") {
            api.showErrorMessage(DnD.t("action.draganddrop.msgVariableIsNotColumn"));
            api.markError("columnFileId")
            return false;
        }

        return true;
    },
    buildForm: function (form) {
        form.addField("dropZoneText");

        const settingZoneFieldSet = form.addFieldSet({
            id: "setting-zone",
            title: DnDPlugin.t("action.draganddrop.labelSettingZone")
        });

        settingZoneFieldSet.addField("columnRender");
        settingZoneFieldSet.addField("columnFileId");
        settingZoneFieldSet.addField({
                id: "additionLock",
                listeners: {
                    change: function (value) {
                        if (!value) {
                            form.hide("additionLockComment");
                        } else {
                            form.show("additionLockComment");
                        }
                    }
                }
            }
        );
        settingZoneFieldSet.addField("additionLockComment");

        const settingDocumentFieldSet = form.addFieldSet({
            id: "setting-document-zone",
            title: DnDPlugin.t("action.draganddrop.labelSettingDocument")
        });

        settingDocumentFieldSet.addField("description");
        settingDocumentFieldSet.addField({
            id: "showWindow",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("showIndexes");
                        form.show("checkRights");
                        form.show("autoSelectFirst");
                        form.show("documentClassNameList");
                        form.hide("indexesTable");
                        form.hide("documentClassId");
                        form.hide("saveAsNewVersion");
                        settingDocumentFieldSet.hide("saveAsNewDocumentVersion");
                    } else {
                        form.hide("showIndexes");
                        form.hide("checkRights");
                        form.hide("autoSelectFirst");
                        form.hide("documentClassNameList");
                        form.show("documentClassId");
                        form.hide("saveAsNewVersion");
                        settingDocumentFieldSet.show("saveAsNewDocumentVersion");

                        indexesTable.clear();
                        const classNameValue = form.getValue("documentClassId");
                        const position = form.getFieldPosition("indexesId");
                        form.removeField("indexesId");

                        if (classNameValue === "") {
                            form.hide("indexesTable");
                        } else if (form.hasVariableValue("documentClassId") || form.hasFunctionValue("documentClassId")) {
                            indexesTable.addField("indexesId", position);
                            form.show("indexesTable");
                        } else {
                            DnDPlugin.addComboboxClassIndexList("indexesId", classNameValue, null, indexesTable, position);
                            form.show("indexesTable");
                        }
                    }
                }
            }
        });

        DnDPlugin.addComboboxClassList("documentClassNameList", null, form, null);

        form.addField("showIndexes");
        form.addField("checkRights");
        form.addField("autoSelectFirst");
        form.addField("saveAsNewVersion");
        form.addField("allowedExtensions");

        settingDocumentFieldSet.addCombobox({
            id: "saveAsNewDocumentVersion",
            values: [
                {id: "default", display: DnDPlugin.t("action.draganddrop.default")},
                {id: "repeatingIndexes", display: DnDPlugin.t("action.draganddrop.repeatingIndexes")},
                {id: "overwritePreviousFileId", display: DnDPlugin.t("action.draganddrop.overwritePreviousFileId")}
            ]
        });

        if (form.getValue("saveAsNewVersion") && !form.getValue("saveAsNewDocumentVersion")) {
            form.setValue("saveAsNewDocumentVersion", "repeatingIndexes");
        }

        form.hide("saveAsNewVersion");

        DnDPlugin.addComboboxClassList("documentClassId", {
            change: function(value) {
                indexesTable.clear();
                const position = form.getFieldPosition("indexesId");
                switchIndexesTableVisibility(value, position);
            }
        }, settingDocumentFieldSet, null);
        settingDocumentFieldSet.addField("saveAsNewVersion");

        const indexesTable = form.addTable({
            id: "indexesTable",
            name: "Indeksy",
            hidden: false
        });
        indexesTable.addField("indexesId");
        indexesTable.addField("indexesValue");


        if (form.getValue("additionLock") === false) {
            form.hide("additionLockComment");
        } else {
            form.show("additionLockComment");
        }

        if (form.getValue("showWindow") === false) {
            form.hide("showIndexes");
            form.hide("checkRights");
            form.hide("autoSelectFirst");
            form.hide("documentClassNameList");

            form.show("documentClassId");
            form.hide("saveAsNewVersion");
            form.show("indexesTable");
            settingDocumentFieldSet.show("saveAsNewDocumentVersion");

            const classNameValue = form.getValue("documentClassId");
            const position = form.getFieldPosition("indexesId");
            switchIndexesTableVisibility(classNameValue, position);
        } else {
            form.show("showIndexes");
            form.show("checkRights");
            form.show("autoSelectFirst");
            form.show("documentClassNameList");

            form.hide("indexesTable");
            form.hide("documentClassId");
            form.hide("saveAsNewVersion");
            settingDocumentFieldSet.hide("saveAsNewDocumentVersion");
        }

        form.show("setting-zone");
        form.show("setting-document-zone");

        function switchIndexesTableVisibility(value, position) {
            form.removeField("indexesId");

            if (value === "") {
                form.hide("indexesTable");
            } else {
                if (form.hasVariableValue("documentClassId") || form.hasFunctionValue("documentClassId")) {
                    indexesTable.addField("indexesId", position);
                } else {
                    DnDPlugin.addComboboxClassIndexList("indexesId", value, null, indexesTable, position);
                }

                form.show("indexesTable");
            }
        }
    }
});