/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drag_and_drop.document.servlet;

import com.suncode.plugin.drag_and_drop.document.dto.DocumentClassDto;
import com.suncode.plugin.drag_and_drop.document.dto.DocumentClassIndexesDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/documentclasses"})
public class DocumentsClassController {
    @Autowired
    private DocumentClassService docClassService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<DocumentClassDto> getDocClassIdsAndNames() {
        ArrayList<DocumentClassDto> classIdsAndNames = new ArrayList<DocumentClassDto>();
        for (DocumentClass docClass : this.docClassService.getAll(new String[0])) {
            classIdsAndNames.add(new DocumentClassDto(docClass.getId(), docClass.getName()));
        }
        return classIdsAndNames;
    }

    @RequestMapping(value={"{classId}/indexes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DocumentClassIndexesDto> getDocClassIndexesIdsAndNames(@PathVariable(value="classId") Long classId) {
        ArrayList<DocumentClassIndexesDto> classIndexesIdsAndNames = new ArrayList<DocumentClassIndexesDto>();
        for (DocumentClassIndex docClassIndexes : ((DocumentClass)this.docClassService.get((Serializable)classId, new String[]{"indexes"})).getIndexes()) {
            classIndexesIdsAndNames.add(new DocumentClassIndexesDto(docClassIndexes.getId(), docClassIndexes.getName()));
        }
        return classIndexesIdsAndNames;
    }
}

