/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drag_and_drop.document.servlet;

import com.google.gson.Gson;
import com.suncode.plugin.drag_and_drop.document.dto.RestResult;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/docs"})
public class DocumentController {
    private static Logger log = LoggerFactory.getLogger(DocumentController.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ResponseBody
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public RestResult handleFileUpload(@RequestParam(value="files") MultipartFile[] files, @RequestParam(value="settings") String settingsJson) {
        String status = "";
        RestResult result = new RestResult(false, status, -1L);
        Gson gson = new Gson();
        Map settings = (Map)gson.fromJson(settingsJson, new HashMap().getClass());
        Long documentClassId = -1L;
        String documentClassName = settings.get("documentClassId").toString();
        try {
            documentClassId = Long.parseLong(documentClassName);
        }
        catch (NumberFormatException nfe) {
            List classes = this.docClassService.getAll(new String[0]);
            for (DocumentClass docClass : classes) {
                if (!docClass.getName().equals(documentClassName)) continue;
                documentClassId = docClass.getId();
                break;
            }
        }
        Map settingsIdx = (Map)settings.get("indexes");
        HashMap newIdx = new HashMap();
        for (String key : settingsIdx.keySet()) {
            newIdx.put(this.getIndexId(key, documentClassId), settingsIdx.get(key));
        }
        log.debug("index mapping: {}", newIdx);
        MultipartFile[] multipartFileArray = files;
        int n = multipartFileArray.length;
        int n2 = 0;
        while (true) {
            block22: {
                if (n2 >= n) {
                    return result;
                }
                MultipartFile file = multipartFileArray[n2];
                if (!file.isEmpty()) {
                    try (InputStream is = file.getInputStream();){
                        DocumentDefinition definition = new DocumentDefinition();
                        definition.setDocumentClassId(documentClassId);
                        definition.setFileName(file.getOriginalFilename());
                        definition.setUserName(settings.get("userName").toString());
                        definition.setInputStream(is);
                        definition.setProcessId(settings.get("processId").toString());
                        definition.setActivityId(settings.get("activityId").toString());
                        if (settings.get("description") != null) {
                            definition.setDescription(settings.get("description").toString());
                        }
                        definition.setIndexes(newIdx);
                        definition.setSaveAsNewVersion(settings.get("saveAsNewVersion") == null ? false : (Boolean)settings.get("saveAsNewVersion"));
                        WfDocument wfDocument = this.documentService.addDocument(definition);
                        long fileId = wfDocument.getFile().getId();
                        result.setSuccess(true);
                        status = status + "\nAdded " + file.getOriginalFilename();
                        result.setMessage(status);
                        result.setFileId(fileId);
                        break block22;
                    }
                    catch (Exception e) {
                        log.debug("File" + file.getOriginalFilename() + " has not been uploaded: " + e.getClass().getSimpleName() + " : " + e.getMessage(), (Throwable)e);
                        status = status + "\nFile" + file.getOriginalFilename() + " has not been uploaded: " + e.getClass().getSimpleName() + " : " + e.getMessage();
                        result.setMessage(status);
                        result.setSuccess(false);
                        return result;
                    }
                }
                log.debug("Uploaded file is empty");
                status = "Uploaded file is empty";
                result.setMessage(status);
            }
            ++n2;
        }
    }

    private Long getIndexId(String nameOrId, Long classId) {
        if (StringUtils.isBlank((CharSequence)nameOrId)) {
            log.debug("No index name or id");
            return null;
        }
        try {
            return Long.parseLong(nameOrId);
        }
        catch (NumberFormatException nfe) {
            List docClassindex = this.documentClassIndexFinder.findByDocumentClass(classId);
            for (DocumentClassIndex documentClassIndex : docClassindex) {
                if (!documentClassIndex.getName().equals(nameOrId)) continue;
                return documentClassIndex.getId();
            }
            log.debug("No finded index id for key: " + nameOrId);
            return null;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/addfiletoprocess"}, method={RequestMethod.POST})
    public void addFileToProcess(@RequestParam(value="fileId") Long fileId, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        WfDocument doc = this.documentService.getDocument(fileId);
        this.documentService.attachDocumentToProcess(doc, "admin", processId, activityId);
    }
}

