window.DnDPlugin = {

	t: PW.I18N.createT('com.suncode.plugin-drag-and-drop'),

	setDocumentDataObtainedFromServlet: function (object, form, url) {
		var cfg = new Object();
		if (Object.prototype.toString.call(object) === '[object String]') {
			cfg.id = object;
		} else {
			cfg = object;
		}
		var formComboValues = this.formComboValues,
			position = form.getFieldPosition(cfg.id);
		jQuery.ajax({
				type: "GET",
				url: url,
				async: true
			})
			.done(function (data) {
				form.removeField(cfg.id);
				cfg.values = formComboValues(data);
				form.insertCombobox(position, cfg);
			})
			.fail(function () {
				Logger.error("Request error.");
			});
	},

	obtainDocClassIdsAndNamesForCombobox: function (id, form) {
		this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("documentclasses"));
	},
	obtainDocClassIndexesIdsAndNamesForCombobox: function (id, form, param) {
		if (param) {
			this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("documentclasses/" + param + "/indexes"));
		} else {
			Logger.error("No param set.")
		}
	},

	formComboValues: function (values) {
		var comboValues = [];
		if (values instanceof Array) {
			for (var i = 0; i < values.length; i++) {
				comboValues.push({
					id: values[i].id.toString(),
					display: values[i].name
				});
			}
		} else {
			for (var key in values) {
				if (values.hasOwnProperty(key)) {
					comboValues.push({
						id: key,
						display: values[key]
					});
				}
			}
		}
		return comboValues;
	},

	prepareUrl: function (endpoint) {
		var url = PlusWorkflow.getAbsolutePath("/plugin/com.suncode.plugin-drag-and-drop/" + endpoint);
		return url;
	},
	addComboboxClassList: function (idName, listenersFn, form, position) {
		form.addCombobox({
			id: idName,
			hidden: false,
			optional: true,
			remote: {
				url: "plugin/com.suncode.plugin-drag-and-drop/api/docClassList",
				fields: [{
						name: "docClassId",
						type: "string"
					},
					{
						name: "docClassName",
						type: "string"
					},
					{
						name: "docClassDesc",
						type: "string"
					}
				]
			},
			valueField: "docClassName",
			displayField: "docClassName",
			sort: [{
				property: "docClassName",
				direction: "ASC"
			}],
			listeners: listenersFn
		}, position)
	},
	addComboboxClassIndexList: function (idName, className, listenersFn, form, position) {
		if (className != undefined) {
		return	form.addCombobox({
				id: idName,
				remote: {
					url: "plugin/com.suncode.plugin-drag-and-drop/api/docClassIndexList/" + className,
					fields: [{
							name: "docClassIndexId",
							type: "string"
						},
						{
							name: "docClassIndexName",
							type: "string"
						},
						{
							name: "docClassIndexDesc",
							type: "string"
						},
						{
							name: "docClassIndexType",
							type: "string"
						}
					]
				},
				template: [{
						label: DnDPlugin.t("dpwe-doc-class-index.name"),
						field: "docClassIndexName"
					},
					{
						label: DnDPlugin.t("dpwe-doc-class-index.desc"),
						field: "docClassIndexDesc"
					},
					{
						label: DnDPlugin.t("dpwe-doc-class-index.type"),
						field: "docClassIndexType"
					}
				],
				valueField: "docClassIndexName",
				displayField: "docClassIndexName",
				sort: [{
					property: "docClassIndexName",
					direction: "ASC"
				}],
				listeners: listenersFn
			}, position);
		} else {
			form.addField({
				id: idName,
				listeners: listenersFn
			}, position);
			return null;
		}
	},
};