/**
 * PWE form of drag-and-drop-document.
 */
PWE.integrationComponent.registerFormAction('drag-and-drop-document', {
    apiVersion: 2,
    buildForm: function (form, options) {

        form.addField('dropZoneText');

        var settingDocumentFieldSet = form.addFieldSet({
            id: "setting-document-zone",
            title: DnDPlugin.t("action.draganddrop.labelSettingDocument")
        });
        settingDocumentFieldSet.addField('description');

        var idexesTable;
        settingDocumentFieldSet.addField({
            id: 'showWindow',
            listeners: {
                change: function (value) {
                    if (value) {
                        //opcja z oknem
                        form.show('showIndexes');
                        form.show('checkRights');
                        form.show('autoSelectFirst');
                        form.show('documentClassIdList');

                        form.hide('idexesTable');
                        form.hide('documentClassId');
                        form.hide('saveAsNewVersion');

                    } else {
                        //opcja bez okna
                        form.hide('showIndexes');
                        form.hide('checkRights');
                        form.hide('autoSelectFirst');
                        form.hide('documentClassIdList');


                        form.show('documentClassId');
                        form.show('saveAsNewVersion');
                        idexesTable.clear();
                        var classNameValue = form.getValue('documentClassId');
                        var pos = form.getFieldPosition('indexesId');
                        form.removeField('indexesId');
                        if (classNameValue === '') {
                            form.hide('idexesTable');
                        } else if (form.hasVariableValue('documentClassId') || form.hasFunctionValue('documentClassId')) {
                            idexesTable.addField('indexesId', pos);
                            form.show('idexesTable');
                        } else {
                            DnDPlugin.addComboboxClassIndexList('indexesId', classNameValue, null, idexesTable, pos);
                            form.show('idexesTable');
                        }
                    }
                }
            }
        });

        form.addField({
            id: "additionalSettingZone",
            listeners: {
                change: function (value) {
                    if (value) {
                        addAdditionalSettingZone(form);
                    } else {
                        form.hide("setting-zone");
                    }
                }
            }
        });

        if (form.getValue("additionalSettingZone")) {
            addAdditionalSettingZone(form);
        } else {
            form.hide("setting-zone");
        };

//opcja z oknem
        DnDPlugin.addComboboxClassList("documentClassIdList", null, form, null);
        form.addField('showIndexes');
        form.addField('checkRights');
        form.addField('autoSelectFirst');
//opcja bez okna
        DnDPlugin.addComboboxClassList('documentClassId', {
            change: function (value) {
                idexesTable.clear();
                var pos = form.getFieldPosition('indexesId');
                form.removeField('indexesId');
                if (value === '') {
                    form.hide('idexesTable');
                } else if (form.hasVariableValue('documentClassId') || form.hasFunctionValue('documentClassId')) {
                    idexesTable.addField('indexesId', pos);
                    form.show('idexesTable');
                } else {
                    DnDPlugin.addComboboxClassIndexList('indexesId', value, null, idexesTable, pos);
                    form.show('idexesTable');
                }
            }
        }, settingDocumentFieldSet, null);
        settingDocumentFieldSet.addField('saveAsNewVersion');
        settingDocumentFieldSet.addField('allowedExtensions');
        idexesTable = form.addTable({
            id: 'idexesTable',
            name: 'Indeksy',
            hidden: false
        });
        idexesTable.addField('indexesId');
        idexesTable.addField('indexesValue');

        convertDocClassIdtoDocClassName(form, idexesTable, init);

        form.show("setting-zone");
        form.show("setting-document-zone");
    }

})
;

function convertDocClassIdtoDocClassName(form, idexesTable, callback) {
    jQuery.ajax({
        url: PlusWorkflow.getAbsolutePath('plugin/com.suncode.plugin-drag-and-drop/api/docClasses'),
        type: 'GET',
        success: function (data) {
            var map = {};
            jQuery.each(data, function (index, item) {
                map[item.id] = item.name;
            });
            var docId = form.getValue('documentClassId');
            if (docId && !isNaN(Number(docId))) {
                form.setValue('documentClassId', map[docId]);
            }
            var arrTemp = [];
            jQuery.each(form.getValue('documentClassIdList'), function (index, item) {
                if (item && !isNaN(Number(item))) {
                    arrTemp.push(map[item])
                } else {
                    arrTemp.push(item);
                }
            });
            form.setValue('documentClassIdList', arrTemp);
        },
        error: function (data) {
            Logger.error(data);
        },
        complete: function () {
            callback(form, idexesTable);
        }
    });

}

function init(form, idexesTable) {
    if (form.getValue('showWindow') == false) {
        form.hide('showIndexes');
        form.hide('checkRights');
        form.hide('autoSelectFirst');
        form.hide('documentClassIdList');

        form.show('documentClassId');
        form.show('saveAsNewVersion');
        form.show('idexesTable');
        var classNameValue = form.getValue('documentClassId');
        var pos = form.getFieldPosition('indexesId');
        form.removeField('indexesId');
        if (classNameValue === '') {
            form.hide('idexesTable');
        } else if (form.hasVariableValue('documentClassId') || form.hasFunctionValue('documentClassId')) {
            idexesTable.addField('indexesId', pos);
            form.show('idexesTable');
        } else {
            DnDPlugin.addComboboxClassIndexList('indexesId', classNameValue, null, idexesTable, pos);
            form.show('idexesTable');
        }
    } else {
        form.show('showIndexes');
        form.show('checkRights');
        form.show('autoSelectFirst');
        form.show('documentClassIdList');

        form.hide('idexesTable');
        form.hide('documentClassId');
        form.hide('saveAsNewVersion');
    }
}

function addAdditionalSettingZone(form) {
        var settingZoneFieldSet = form.addFieldSet({
            id: "setting-zone",
            title: DnDPlugin.t("action.draganddrop.labelSettingZone")
        });

        settingZoneFieldSet.addCombobox({
            id: "position",
            values: [
                {id: "TOP", display: DnDPlugin.t('action.draganddrop.position.top')},
                {id: "BOTTOM", display: DnDPlugin.t('action.draganddrop.position.bottom')},
                {id: "LEFT", display: DnDPlugin.t('action.draganddrop.position.left')},
                {id: "RIGHT", display: DnDPlugin.t('action.draganddrop.position.right')}
            ],

        }, form.getFieldPosition('variableId'));

        settingZoneFieldSet.addField({
            id: "variableId"
        });
}