/**
 * Implementation of DragAndDrop
 */
PW.FormActions.create('drag-and-drop-document', {

    formInit: function () {
        this.idDropZone = 'dropZone-' + Math.floor(Math.random() * 1000);
    },
    enable: function () {
        var vartiableId = null;
        var variable = this.get("variableId");
        if (variable) {
            vartiableId = variable.getId();
            if (variable.field.hidden) {
                return;
            }
        }
        ;

        var before = false;
        var sameLine = false;
        var position = this.get('position');
        if (position == 'TOP') {
            before = true;
            sameLine = false;
        } else if (position == 'RIGHT') {
            before = false;
            sameLine = true;
        } else if (position == 'LEFT') {
            before = true;
            sameLine = true;
        } else {
            before = false;
            sameLine = false;
        }
        var html = this.dropZone(this.idDropZone, this.get('dropZoneText'), position, vartiableId);
        if ((position == 'TOP' || position == 'BOTTOM') || ((position == 'RIGHT' || position == 'LEFT') && variable !== null)) {

            var field = Ext4.getCmp(vartiableId);
            if (field && field.xtype === 'textarea' && (position === 'RIGHT' || position === 'LEFT')) {
                field.on('resize', function (_, __, newHeight) {
                    document.getElementById(jQuery.parseHTML(html)[0].id).style.lineHeight = (newHeight - 5) + 'px';
                });
                if (position === 'LEFT') {
                    var actualDistance = field.el.dom.parentElement.style.left.toString();
                    var getNum = actualDistance.replace(/^\D+/g, '');
                    var num = parseInt(getNum);
                    num += 205;
                    var leftDistance = num.toString();
                    field.el.dom.parentElement.style.left = leftDistance + 'px';
                }
            }
            FormService.insertHtml(html, vartiableId, before, sameLine);
        }

        Ext4.defer(function () {
            var dz = jQuery('#' + this.idDropZone);
            dz.on("dragleave", this.dragLeave);
            dz.on("dragover", this.dragOver);
            dz.on("drop", this.dragDrop);
            dz.on("dragenter", this.dragEnter);
            dz.data(this);
        }, 1, this);

    },

    disable: function () {
        jQuery("#" + this.idDropZone).remove();
        FormService.suncodeForm.doComponentLayout();

        var vartiableId = null;
        var variable = this.get("variableId");
        if (variable) {
            vartiableId = variable.getId();
        }
        var position = this.get('position');
        var field = Ext4.getCmp(vartiableId);
        if (field && field.xtype === 'textarea') {
            if (position === 'LEFT') {
                field.el.dom.parentElement.style.left = '-5px';
            }
        }

    },
    dropZone: function (idDropZone, textDropZone, position, vartiableId) {
        var tempDiv = jQuery('<div/>');
        var dropZone = jQuery('<div/>', {
            id: idDropZone,
            text: textDropZone
        });

        dropZone.addClass('suncode-form-grey-panel');
        dropZone.addClass("suncode-form-label");
        dropZone.css('border', '2px dashed #cfcfcf');
        dropZone.css('text-align', 'center');

        let isDivante = parent.window.PW?.ui?.version === 1;
        let variable = this.get("variableId");
        if (variable?.field?.height !== undefined && (position === 'LEFT' || position === 'RIGHT')) {
            dropZone.css('line-height', (variable.field.height - 6) + "px");
        } else if (isDivante) {
            dropZone.css('line-height', '34px');
        }

        if (vartiableId == null || position === 'TOP' || position === 'BOTTOM') {
            dropZone.css("padding", "1em");
            dropZone.css("margin", "1em");
        } else {
            dropZone.css("min-width", "202px");
            dropZone.css("padding", "1px 7px");
            // dropZone.css("height", "27px");
            dropZone.css("display", "inline-block");
            dropZone.css("margin", "0 2px");
            // dropZone.css("position", "absolute");
            // dropZone.css("top", "35px");

        }
        tempDiv.append(dropZone);
        return tempDiv.html();
    },
    dragLeave: function (event) {
        event.stopPropagation();
        event.preventDefault();
        jQuery(event.target).css('border', '2px dashed #cfcfcf');
        var me = jQuery(event.target).data();
        if (me.get('position') == 'LEFT' || me.get('position') == 'RIGHT') {
            jQuery(event.target).css("padding", "1px 7px");
        }

    },
    dragOver: function (event) {
        event.stopPropagation();
        event.preventDefault();
        jQuery(event.target).css('border', '3px dashed #9e9e9e');
        var me = jQuery(event.target).data();
        if (me.get('position') == 'LEFT' || me.get('position') == 'RIGHT') {
            jQuery(event.target).css("padding", "1px 6px");
        }

    },
    dragEnter: function (event) {
        event.stopPropagation();
        event.preventDefault();
        return false;
    },
    sendFiles: function (files, me) {
        var settings = {};
        settings.userName = Suncode.getCurrentUser();
        settings.documentClassId = me.get("documentClassId");
        settings.processId = processId;
        settings.activityId = activityId;
        settings.indexes = me.getIndexes(me);
        settings.description = me.get("description");
        settings.saveAsNewVersion = me.get("saveAsNewVersion") == undefined ? false : me.get("saveAsNewVersion");

        FormService.mask(DnD.t('action.draganddrop.wait'));
        var formData = new FormData();
        for (let i = 0; i < files.length; i++) {
            formData.append('files', files[i]);
        }
        formData.append('settings', JSON.stringify(settings));
        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-drag-and-drop/docs/upload',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data.success) {
                    MessageService.showSuccess(DnD.t('action.draganddrop.msgSuccess'));
                } else {
                    FormService.unmask();
                    Logger.error(data.message);
                    MessageService.showFailure(DnD.t('action.draganddrop.msgError'));
                }
            },
            error: function (data) {
                FormService.unmask();
                MessageService.showFailure(DnD.t('action.draganddrop.msgError'));
                Logger.error(data.message);
            },
            complete: function () {
                FormService.unmask();
                DocumentService.refreshDocuments();
            }
        });
    },
    getIndexes: function (me) {
        var result = {};
        var indexIds = me.get('indexesId');
        var indexesValue = me.get('indexesValue');
        PW.each(indexIds, function (item, index) {
            if (index < indexesValue.length) {
                let value = indexesValue[index]?.getValue();
                if (value instanceof Date) {
                    value = me.toLocalISOString(value);
                }

                result[item] = value;
            }
        });
        return result;
    },
    toLocalISOString: function (date) {
        const timezoneOffset = date.getTimezoneOffset() * 60000;
        const localTime = new Date(date - timezoneOffset);
        return localTime.toISOString().slice(0, -1);
    },
    dragDrop: function (event) {
        event.stopPropagation();
        event.preventDefault();
        jQuery(event.target).css('border', '2px dashed #cfcfcf');
        var me = jQuery(event.target).data();
        if (me.get('position') == 'LEFT' || me.get('position') == 'RIGHT') {
            jQuery(event.target).css("padding", "1px 7px");
        }
        var files;
        if (event.target.files) {
            files = event.target.files
        } else if (event.dataTransfer) {
            files = event.dataTransfer.files;
        } else {
            files = event.originalEvent.dataTransfer.files;
        }


        docClassIdArr = [];
        docClassNameArr = [];
        //Dla kompatybilności wstecz zwracany jest id, w nowych komponetach nazwa klasy
        jQuery.each(me.get('documentClassIdList'), function (index, item) {
            if (item && isNaN(Number(item))) {
                docClassNameArr.push(item)
            } else if (item && !isNaN(Number(item))) {
                docClassIdArr.push(item);
            }
        });

        if (!me.checkExtension(files)) {
            return;
        }

        if (me.get('showWindow')) {
            var cfg = {
                showIndexes: me.get('showIndexes'),
                checkRights: me.get('checkRights'),
                autoSelectFirst: me.get('autoSelectFirst'),
                documentClassIdList: docClassIdArr,
                documentClassNameList: docClassNameArr,
                refreshAfterAdd: false,
                callback: function () {
                    DocumentService.refreshDocuments();
                },
                files: files
            };
            CUF.DocumentService.showAddDocumentsFromDiscForm(cfg);
        } else {
            me.sendFiles(files, me)
        }
    },

    checkExtension: function (files) {
        let limitExtensions = this.get("allowedExtensions");
        let result = true;
        if (limitExtensions) {
            limitExtensions = limitExtensions.replaceAll(' ', '')
            let extensions = limitExtensions.split(',');
            for (let fileIndex = 0; fileIndex < files.length; fileIndex++) {
                let fileName = files[fileIndex].name.toString();
                let fileNameAndExtension = fileName.split(".");
                if (fileNameAndExtension.length < 2) {
                    MessageService.showFailure(DnD.t('action.draganddrop.emptyExtension'));
                    result = false;
                    break;
                } else {
                    let ext = fileNameAndExtension.pop();
                    if (!extensions.includes(ext)) {
                        MessageService.showFailure(DnD.t('action.draganddrop.wrongExtension') + limitExtensions);
                        result = false;
                        break;
                    }
                }
            }
        }
        return result;
    }
});