PW.FormActions.create("dnd-table", {
    variableSetInit: function (table) {
        this.table = VariableSetService.get(table.getId());
        this.idDropZone = "dropZone-" + Math.floor(Math.random() * 1000);
    },
    enable: function () {
        const me = this;
        VariableSetService.addRenderer(this.table, function (value, data, column, metaData) {
            metaData.encode = false;
            const div = jQuery("<div/>");
            const html = me.dropZone(me, metaData.row);
            div.append(html);

            if (!window.isHistory) {
                Ext4.defer(function () {
                    const dropZone = jQuery("#" + me.idDropZone + "-row_" + metaData.row);
                    if (dropZone.get(0) === undefined ||
                        (jQuery._data(dropZone.get(0), "events") !== undefined && jQuery._data(dropZone.get(0), "events").drop !== undefined)) {
                        return;
                    }

                    dropZone.on("dragleave", me.dragLeave);
                    dropZone.on("dragover", me.dragOver);
                    dropZone.on("drop", me.dragDrop);
                    dropZone.on("dragenter", me.dragEnter);
                    dropZone.data(me);
                }, 1, me);
            }

            return div.html();
        }, [this.get("columnRender").getId()]);

    },
    disable: function () {
        VariableSetService.removeRenderers(this.table, [this.get("columnRender").getId()]);
    },
    dropZone: function (me, row) {
        this.idDropZone = me.idDropZone;
        me.setContextVariable("currentRow", row);

        const tempDiv = jQuery("<div/>");
        const dropZone = jQuery("<div/>", {
            id: this.idDropZone + "-row_" + row,
            text: me.get("dropZoneText")
        });

        dropZone.addClass("suncode-form-grey-panel");
        dropZone.addClass(this.idDropZone);
        dropZone.addClass("suncode-form-label");
        dropZone.css("border", "2px dashed #cfcfcf");
        dropZone.css("text-align", "center");
        dropZone.css("line-height", "40px");
        dropZone.css("margin", "-12px -16px");
        tempDiv.append(dropZone);

        return tempDiv.html();
    },
    dragLeave: function (event) {
        event.stopPropagation();
        event.preventDefault();
        jQuery(event.target).css("border", "2px dashed #cfcfcf");
    },
    dragOver: function (event) {
        event.stopPropagation();
        event.preventDefault();
        const dropZone = jQuery(event.target)
        const rowIndex = Number(dropZone.attr("id").split("_")[1]);
        const me = jQuery(event.target).data();

        me.setContextVariable("currentRow", rowIndex);
        if (!me.get("additionLock")) {
            dropZone.css("border", "3px dashed #9e9e9e");
        }
    },
    dragEnter: function (event) {
        event.stopPropagation();
        event.preventDefault();
    },
    sendFiles: function (files, me, rowIndex, columnFileId) {
        const cfg = {};
        cfg.userName = Suncode.getCurrentUser();
        cfg.documentClassId = me.get("documentClassId");
        cfg.processId = window.processId;
        cfg.activityId = window.activityId;
        cfg.indexes = me.getIndexes(me);
        cfg.description = me.get("description");

        if (me.get("saveAsNewVersion") && !me.get("saveAsNewDocumentVersion")) {
            cfg.saveAsNewVersion = true;
        } else {
            cfg.saveAsNewVersion = me.get("saveAsNewDocumentVersion") === "repeatingIndexes";
        }

        FormService.mask(DnD.t("action.draganddrop.wait"));
        const formData = new FormData();
        for (let i = 0; i < files.length; i++) {
            formData.append("files", files[i]);
        }

        formData.append("settings", JSON.stringify(cfg));
        jQuery.ajax({
            url: "plugin/com.suncode.plugin-drag-and-drop/docs/upload",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data.success) {
                    VariableSetService.setValue(me.table, rowIndex, columnFileId, data.fileId);
                    MessageService.showSuccess(DnD.t("action.draganddrop.msgSuccess"));
                    VariableSetService.save(me.table);
                } else {
                    Logger.error(data.message);
                    MessageService.showFailure(DnD.t("action.draganddrop.msgError"));
                }
            },
            error: function (data) {
                Logger.error(data.message);
                MessageService.showFailure(DnD.t("action.draganddrop.msgError"));
            },
            complete: function () {
                FormService.unmask();
                DocumentService.refreshDocuments();
            }
        });
    },
    getIndexes: function (me) {
        const result = {};
        const indexIds = me.get("indexesId");
        const indexesValue = me.get("indexesValue");

        PW.each(indexIds, function (item, index) {
            if (index < indexesValue.length) {
                let value = indexesValue[index];
                if (value instanceof Date) {
                    value = me.toLocalISOString(value);
                }

                result[item] = value;
            }
        });
        return result;
    },
    toLocalISOString: function (date) {
        const timezoneOffset = date.getTimezoneOffset() * 60000;
        const localTime = new Date(date - timezoneOffset);
        return localTime.toISOString().slice(0, -1);
    },
    dragDrop: function (event) {
        event.stopPropagation();
        event.preventDefault();
        const dropZone = jQuery(event.target)
        dropZone.css("border", "2px dashed #cfcfcf");
        const rowIndex = Number(dropZone.attr("id").split("_")[1]);
        const me = jQuery(event.target).data();
        me.setContextVariable("currentRow", rowIndex);
        const columnFileId = me.get("columnFileId").getId();
        let files;
        let parentFileId = VariableSetService.getValue(me.table, rowIndex, columnFileId);

        if (me.get("additionLock")) {
            if (me.get("additionLockComment")) {
                MessageService.show(me.get("additionLockComment"));
            }

            return;
        }

        if (parentFileId !== "" && me.get("saveAsNewDocumentVersion") !== "overwritePreviousFileId" && me.get("saveAsNewDocumentVersion") !== "repeatingIndexes") {
            MessageService.showFailure(DnD.t("action.draganddrop.docExist"));
            return;
        }

        if (event.target.files) {
            files = event.target.files;
        } else if (event.dataTransfer) {
            files = event.dataTransfer.files;
        } else {
            files = event.originalEvent.dataTransfer.files;
        }

        if (files.length > 1) {
            MessageService.showFailure(DnD.t("action.draganddrop.tooManyFiles"));
            return;
        }

        if (!me.checkExtension(files)) {
            return;
        }

        if (me.get("showWindow")) {
            const cfg = {
                showIndexes: me.get("showIndexes"),
                checkRights: me.get("checkRights"),
                autoSelectFirst: me.get("autoSelectFirst"),
                documentClassNameList: me.get("documentClassNameList"),
                fileDescription: me.get("description"),
                callback: function (file) {
                    parentFileId = file[0].id;
                    VariableSetService.setValue(me.table, rowIndex, columnFileId, parentFileId);
                    DocumentService.refreshDocuments();
                    VariableSetService.save(me.table);
                },
                files: files
            };

            CUF.DocumentService.showAddDocumentsFromDiscForm(cfg);
        } else {
            if (me.get("saveAsNewDocumentVersion") === "overwritePreviousFileId" && parentFileId !== "") {
                PW.each(files, function (file) {
                    const data = new FormData();
                    data.append("file", file);
                    data.append("comment", "");
                    data.append("parentFileId", parentFileId);
                    data.append("description ", me.get("description"));
                    me.saveNewDocumentVersion(data, rowIndex, columnFileId);
                });
            } else {
                me.sendFiles(files, me, rowIndex, columnFileId);
            }
        }
    },
    saveNewDocumentVersion: function (documentData, rowIndex, columnFileId) {
        const me = jQuery(event.target).data();

        jQuery.ajax({
            url: "api/documents/" + documentData.get("parentFileId") + "/checkOut",
            method: "PUT",
            success: function () {
                const checkInCall = me.checkInCall(documentData);
                checkInCall.fail(() => {
                    MessageService.showFailure(DnD.t("action.draganddrop.msgNewVersionError"));
                    return me.undoCheckOut(documentData);
                });

                const newVersionIdCall = checkInCall.then(() => {
                    MessageService.showSuccess(DnD.t("action.draganddrop.msgNewVersionSuccess"));
                    return me.newVersionIdCall(documentData);
                });

                newVersionIdCall.done(data => {
                    let newestVersion = 0;
                    let newestVersionObject = undefined;

                    for (let i = 0; i < data.length; i++) {
                        const tempNewestFileVersion = data[i].version.version;
                        if (tempNewestFileVersion > newestVersion) {
                            newestVersion = tempNewestFileVersion;
                            newestVersionObject = data[i];
                        }
                    }

                    me.addDocToProcess(newestVersionObject.id);
                    VariableSetService.setValue(me.table, rowIndex, columnFileId, newestVersionObject.id);
                    DocumentService.refreshDocuments();
                });
            },
            error: function (message) {
                Logger.error(message)
            }
        });
    },
    newVersionIdCall: function (data) {
        return jQuery.ajax({
            url: "api/documents/" + data.get("parentFileId") + "/versions",
            method: "GET"
        });
    },
    checkInCall: function (data) {
        return jQuery.ajax({
            url: "api/form/documents/checkIn",
            processData: false,
            contentType: false,
            method: "POST",
            data: data
        });
    },
    undoCheckOut: function (data) {
        jQuery.ajax({
            url: "api/documents/" + data.get("parentFileId") + "/undoCheckOut",
            method: "PUT",
            error: function (message) {
                Logger.error(message)
            }
        });
    },
    addDocToProcess: function (fileId) {
        const formData = new FormData();
        formData.append("fileId", fileId);
        formData.append("processId", window.processId);
        formData.append("activityId", window.activityId);

        jQuery.ajax({
            url: "plugin/com.suncode.plugin-drag-and-drop/docs/addfiletoprocess",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
        });
    },
    checkExtension: function (files) {
        let limitExtensions = this.get("allowedExtensions");
        if (!limitExtensions) {

            return true;
        }

        limitExtensions = limitExtensions.replaceAll(" ", "")
        let extensions = limitExtensions.split(",");

        for (let fileIndex = 0; fileIndex < files.length; fileIndex++) {
            const fileName = files[fileIndex].name.toString();
            const fileNameAndExtension = fileName.split(".");

            if (fileNameAndExtension.length < 2) {
                MessageService.showFailure(DnD.t("action.draganddrop.emptyExtension"));
                return false;
            }

            const ext = fileNameAndExtension.pop();
            if (!extensions.includes(ext)) {
                MessageService.showFailure(DnD.t("action.draganddrop.wrongExtension") + limitExtensions);
                return false;
            }
        }

        return true;
    }
});