/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.drag_and_drop.document.servlet;

import com.suncode.plugin.drag_and_drop.document.dto.DocumentClassDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.SilkIconPack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class DocumentInfo {
    private static final Logger log = LoggerFactory.getLogger(DocumentInfo.class);
    @Autowired
    private DocumentClassService docClassService;

    @RequestMapping(value={"docid/{fileid}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getDocId(@PathVariable(value="fileid") Long fileId) {
        log.debug("GetDocID  from file id\t:" + fileId);
        DocumentService docService = ServiceFactory.getDocumentService();
        WfDocument document = docService.getDocument(fileId);
        if (document != null) {
            Long docId = document.getId();
            return docId.toString();
        }
        return "";
    }

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        List<DocumentClass> classes = this.getAllDocClasses();
        ArrayList<Map> docClassInfoList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        for (DocumentClass documentClass : classes) {
            HashMap<String, String> docClassInfo = new HashMap<String, String>();
            docClassInfo.put("docClassId", documentClass.getId().toString());
            docClassInfo.put("docClassName", documentClass.getName());
            docClassInfo.put("docClassDesc", documentClass.getDescription());
            tempList.add(docClassInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            docClassInfoList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("docClassName")).toLowerCase().contains(query.toLowerCase()) && !((String)map.get("docClassId")).toLowerCase().contains(query.toLowerCase())) continue;
                docClassInfoList.add(map);
            }
        }
        int totalResult = docClassInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(docClassInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(docClassInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    @RequestMapping(value={"/docClasses"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DocumentClassDto> getDocClassIdsAndNames() {
        ArrayList<DocumentClassDto> classIdsAndNames = new ArrayList<DocumentClassDto>();
        for (DocumentClass docClass : this.docClassService.getAll(new String[0])) {
            classIdsAndNames.add(new DocumentClassDto(docClass.getId(), docClass.getName()));
        }
        return classIdsAndNames;
    }

    @RequestMapping(value={"icon"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentIconList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        ArrayList<Map> resultList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        HashMap<String, String> iconInfo = new HashMap<String, String>();
        for (SilkIconPack silkIcon : SilkIconPack.values()) {
            iconInfo = new HashMap();
            iconInfo.put("iconName", silkIcon.getCss().substring(5));
            tempList.add(iconInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            resultList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("iconName")).toLowerCase().contains(query.toLowerCase())) continue;
                resultList.add(map);
            }
        }
        int totalResult = resultList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(resultList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(resultList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    @RequestMapping(value={"docClassIndexList/{className}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassIndexList(@PathVariable(value="className") String className, @RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        DocumentClass temp = this.docClassService.getDocumentClass(className, new String[]{"indexes"});
        Translator t = Translators.get((String)"com.suncode.plugin-drag-and-drop");
        try {
            if (temp == null) {
                temp = (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(className)), new String[]{"indexes"});
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ArrayList dataError = new ArrayList();
            HashMap<String, String> errorResult = new HashMap<String, String>();
            errorResult.put("docClassIndexId", "");
            errorResult.put("docClassIndexName", "");
            errorResult.put("docClassIndexDesc", e.getMessage());
            errorResult.put("docClassIndexType", t.getMessage("drag-and-drop.doc-class.index.type.error"));
            dataError.add(errorResult);
            result.setData(dataError);
            return result;
        }
        Set indexes = temp.getIndexes();
        ArrayList<Map> docClassIndexInfoList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        for (DocumentClassIndex documentClassIndex : indexes) {
            HashMap<String, String> docClassindexInfo = new HashMap<String, String>();
            docClassindexInfo.put("docClassIndexId", documentClassIndex.getId().toString());
            docClassindexInfo.put("docClassIndexName", documentClassIndex.getName());
            docClassindexInfo.put("docClassIndexDesc", documentClassIndex.getDescription());
            docClassindexInfo.put("docClassIndexType", t.getMessage("drag-and-drop.doc-class.index.type." + documentClassIndex.getType().toString()));
            tempList.add(docClassindexInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            docClassIndexInfoList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("docClassIndexName")).toLowerCase().contains(query.toLowerCase()) && !((String)map.get("docClassIndexId")).toLowerCase().contains(query.toLowerCase())) continue;
                docClassIndexInfoList.add(map);
            }
        }
        int totalResult = docClassIndexInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(docClassIndexInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(docClassIndexInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    private List<DocumentClass> getAllDocClasses() {
        return this.docClassService.getAll(new String[0]);
    }
}

