/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.util.web.rest;

import com.suncode.dbexplorer.util.authorization.NotFullRightsException;
import com.suncode.dbexplorer.util.web.rest.RestApiError;
import com.suncode.dbexplorer.util.web.rest.RestApiException;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.web.support.ajax.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/api"}, produces={"application/json"})
public abstract class RestController {
    private static final Logger log = LoggerFactory.getLogger(RestController.class);
    private static final Logger logger = LoggerFactory.getLogger(RestController.class);
    public static final String JSON_TYPE = "application/json";

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<RestApiError> handleException(Exception e) {
        logger.error("REST API error occurred", (Throwable)e);
        RestApiError restApiError = new RestApiError(HttpStatus.INTERNAL_SERVER_ERROR).setMessage("Internal server error occurred");
        return this.createResponseEntity(restApiError);
    }

    @ExceptionHandler(value={RestApiException.class})
    public ResponseEntity<RestApiError> handleRestApiException(RestApiException e) {
        logger.error("REST API error occurred", (Throwable)e);
        return this.createResponseEntity(e.getError());
    }

    protected ResponseEntity<RestApiError> createResponseEntity(RestApiError restApiError) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpStatus responseStatus = HttpStatus.valueOf((int)restApiError.getHttpStatus());
        return new ResponseEntity((Object)restApiError, (MultiValueMap)headers, (HttpStatusCode)responseStatus);
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleUnauthorizedRequests(NotFullRightsException e) {
        Translator translator = Translators.get(RestController.class);
        log.info(translator.getMessage("dbex.no.rights"));
        return new RestResult(false, translator.getMessage("dbex.no.rights"));
    }
}

