/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.util.persistence;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.type.Type;

public class CompositeInterceptor
extends EmptyInterceptor {
    private List<Interceptor> interceptors = Lists.newArrayList();

    public CompositeInterceptor(Interceptor ... interceptor) {
        Collections.addAll(this.interceptors, interceptor);
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean result = false;
        for (Interceptor interceptor : this.interceptors) {
            result |= interceptor.onLoad(entity, id, state, propertyNames, types);
        }
        return result;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        boolean result = false;
        for (Interceptor interceptor : this.interceptors) {
            result |= interceptor.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        }
        return result;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean result = false;
        for (Interceptor interceptor : this.interceptors) {
            result |= interceptor.onSave(entity, id, state, propertyNames, types);
        }
        return result;
    }
}

