/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.util.convert;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.core.convert.converter.Converter;

public class StringToDateConverter
implements Converter<String, Date> {
    private final DateTimeFormatter[] FORMATS = new DateTimeFormatter[]{ISODateTimeFormat.dateOptionalTimeParser()};

    public Date convert(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            long date = Long.parseLong(source.trim());
            return new Date(date);
        }
        catch (NumberFormatException numberFormatException) {
            for (DateTimeFormatter formatter : this.FORMATS) {
                try {
                    DateTime parsed = formatter.parseDateTime(source);
                    return parsed.toDate();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

