/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.util.authorization;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.dbexplorer.alias.permission.AccessLevel;
import com.suncode.dbexplorer.alias.permission.PermissionsService;
import com.suncode.dbexplorer.util.authorization.NotFullRightsException;
import com.suncode.pwfl.administration.user.UserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationHelper {
    private final PermissionsService permissionsService;

    public void assertFullAdministrationRights(Runnable callbackIfHasNoRights) {
        String name = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)name, (boolean)false, (boolean)false);
        if (right != 0) {
            callbackIfHasNoRights.run();
            throw new NotFullRightsException();
        }
    }

    public void hasAccessToTable(String username, String tableName, AccessLevel accessLevel) {
        boolean hasPermissionToTable = this.permissionsService.hasPermissionToTable(username, tableName, accessLevel);
        if (!hasPermissionToTable) {
            throw new NotFullRightsException();
        }
    }

    @Autowired
    public AuthorizationHelper(PermissionsService permissionsService) {
        this.permissionsService = permissionsService;
    }
}

