/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.internal;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasNotFoundException;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.alias.exception.AliasNotActiveException;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@Provides(value={DatabaseExplorer.class})
public class DatabaseExplorerImpl
implements DatabaseExplorer {
    private AliasService aliasService;
    private DatabaseFactory databaseFactory;

    @Autowired
    public DatabaseExplorerImpl(AliasService aliasService, DatabaseFactory databaseFactory) {
        Assert.notNull((Object)aliasService, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)databaseFactory, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.aliasService = aliasService;
        this.databaseFactory = databaseFactory;
    }

    @Override
    public Database get(String name) throws AliasNotFoundException {
        Alias alias = this.aliasService.getAlias(name);
        if (alias == null) {
            throw new AliasNotFoundException(name);
        }
        if (!alias.getIsActive().booleanValue()) {
            Translator translator = Translators.get(DatabaseExplorerImpl.class);
            throw new AliasNotActiveException(translator.getMessage("dbex.alias.notActive.exception", new Object[]{alias.getName()}));
        }
        return this.databaseFactory.create(alias.getWrappedConnectionString());
    }

    @Override
    public AliasService getAliasService() {
        return this.aliasService;
    }

    @Override
    public DatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }
}

