/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.internal;

import com.suncode.dbexplorer.util.persistence.CompositeInterceptor;
import com.suncode.dbexplorer.util.persistence.EntityInjector;
import com.suncode.dbexplorer.util.persistence.JsonInterceptor;
import com.suncode.dbexplorer.util.persistence.PrefixTableNamingStrategy;
import com.suncode.plugin.framework.util.ClassLoaderUtils;
import com.suncode.plugin.framework.web.mvc.MvcModuleConfigurerAdapter;
import com.suncode.pwfl.persistence.support.hibernate.SystemBaseSessionFactoryBean;
import java.util.List;
import org.hibernate.Interceptor;
import org.hibernate.boot.model.naming.CamelCaseToUnderscoresNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class AppConfig
extends MvcModuleConfigurerAdapter {
    private static final String PREFIX = "dbex_";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private ApplicationContext context;

    @Bean
    public LocalSessionFactoryBean sessionFactory() {
        SystemBaseSessionFactoryBean sessionFactoryBean = new SystemBaseSessionFactoryBean(true);
        sessionFactoryBean.setPackagesToScan(new String[]{"com.suncode.dbexplorer"});
        sessionFactoryBean.setPhysicalNamingStrategy((PhysicalNamingStrategy)new PrefixTableNamingStrategy(PREFIX, (PhysicalNamingStrategy)new CamelCaseToUnderscoresNamingStrategy()));
        JsonInterceptor json = new JsonInterceptor();
        EntityInjector injector = new EntityInjector(this.context);
        sessionFactoryBean.setEntityInterceptor((Interceptor)new CompositeInterceptor(new Interceptor[]{json, injector}));
        return sessionFactoryBean;
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        return new HibernateTransactionManager(this.sessionFactory().getObject());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        String className = "com.suncode.pwfl.web.support.io.DownloadResourceHttpMessageConverter";
        try {
            Class clazz = ClassLoaderUtils.loadSystemClass((String)className);
            converters.add(0, (HttpMessageConverter)clazz.newInstance());
        }
        catch (Exception e) {
            this.logger.warn("Could not find class [{}] in system classloader. Excel export will fail.", (Object)className, (Object)e);
        }
    }
}

