/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.query;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.query.Order;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public class Pagination {
    private static final int DEFAULT_PAGE_SIZE = 50;
    private final int page;
    private int pageSize;
    private final List<Order> order = Lists.newArrayList();

    public Pagination(int page) {
        this(page, new Order[0]);
    }

    public Pagination(int page, Order ... order) {
        this(page, 50, order);
    }

    public Pagination(int page, int pageSize, Order ... order) {
        this.page = page > 0 ? page : 1;
        this.pageSize = pageSize;
        Collections.addAll(this.order, order);
    }

    public int getPage() {
        return this.page;
    }

    public int getStart() {
        return (this.page - 1) * this.pageSize;
    }

    public int getLimit() {
        return this.pageSize;
    }

    public List<Order> getOrder() {
        return this.order;
    }

    public boolean hasOrder() {
        return !this.order.isEmpty();
    }

    public void addOrder(Order order) {
        Assert.notNull((Object)order, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.order.add(order);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

