/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.type;

import com.suncode.dbexplorer.database.internal.type.HibernateDataTypeHandler;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;
import com.suncode.dbexplorer.database.type.StringDataType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class StringDataTypeHandler
extends HibernateDataTypeHandler {
    @Override
    public DataType create(NativeType nativeType) {
        return new StringDataType(nativeType);
    }

    @Override
    protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
        if (value instanceof Number) {
            Number number = (Number)value;
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            DecimalFormat format = new DecimalFormat("#.####################", symbols);
            return format.format(number.doubleValue());
        }
        return value.toString();
    }

    @Override
    protected Type resolveHibernateType(DataType dataType) {
        return StandardBasicTypes.STRING;
    }
}

