/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.type;

import com.google.common.collect.Maps;
import com.suncode.dbexplorer.database.internal.type.BinaryDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.BooleanDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.DataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.DataTypeRegistry;
import com.suncode.dbexplorer.database.internal.type.DateDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.DateTimeDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.FloatDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.IntegerDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.StringDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.TimeDataTypeHandler;
import com.suncode.dbexplorer.database.internal.type.UnknownDataTypeHandler;
import com.suncode.dbexplorer.database.type.BinaryDataType;
import com.suncode.dbexplorer.database.type.BooleanDataType;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.DateDataType;
import com.suncode.dbexplorer.database.type.DateTimeDataType;
import com.suncode.dbexplorer.database.type.FloatDataType;
import com.suncode.dbexplorer.database.type.IntegerDataType;
import com.suncode.dbexplorer.database.type.NativeType;
import com.suncode.dbexplorer.database.type.StringDataType;
import com.suncode.dbexplorer.database.type.TimeDataType;
import com.suncode.dbexplorer.database.type.UnknownDataType;
import java.util.Map;
import org.springframework.util.Assert;

public abstract class DefaultDataTypeRegistry
implements DataTypeRegistry {
    private final Map<Class<? extends DataType>, DataTypeHandler> typeHandlers = Maps.newHashMap();
    private final Map<Integer, Class<? extends DataType>> sqlTypeMapping = Maps.newHashMap();
    private final Map<String, Class<? extends DataType>> nativeTypeMapping = Maps.newHashMap();

    public DefaultDataTypeRegistry() {
        this.registerTypeHandler(StringDataType.class, new StringDataTypeHandler());
        this.mapType(1, StringDataType.class);
        this.mapType(-15, StringDataType.class);
        this.mapType(12, StringDataType.class);
        this.mapType(-9, StringDataType.class);
        this.mapType(-1, StringDataType.class);
        this.mapType(-16, StringDataType.class);
        this.registerTypeHandler(IntegerDataType.class, new IntegerDataTypeHandler());
        this.registerTypeHandler(FloatDataType.class, new FloatDataTypeHandler());
        this.mapType(-6, IntegerDataType.class);
        this.mapType(5, IntegerDataType.class);
        this.mapType(4, IntegerDataType.class);
        this.mapType(-5, IntegerDataType.class);
        this.mapType(3, FloatDataType.class);
        this.mapType(2, FloatDataType.class);
        this.mapType(8, FloatDataType.class);
        this.mapType(6, FloatDataType.class);
        this.mapType(7, FloatDataType.class);
        this.registerTypeHandler(DateTimeDataType.class, new DateTimeDataTypeHandler());
        this.registerTypeHandler(DateDataType.class, new DateDataTypeHandler());
        this.registerTypeHandler(TimeDataType.class, new TimeDataTypeHandler());
        this.mapType(93, DateTimeDataType.class);
        this.mapType(91, DateDataType.class);
        this.mapType(92, TimeDataType.class);
        this.registerTypeHandler(BinaryDataType.class, new BinaryDataTypeHandler());
        this.mapType(-2, BinaryDataType.class);
        this.mapType(-3, BinaryDataType.class);
        this.mapType(-4, BinaryDataType.class);
        this.mapType(2004, BinaryDataType.class);
        this.mapType(2005, BinaryDataType.class);
        this.mapType(2011, BinaryDataType.class);
        this.registerTypeHandler(BooleanDataType.class, new BooleanDataTypeHandler());
        this.mapType(-7, BooleanDataType.class);
        this.mapType(16, BooleanDataType.class);
        this.registerTypeHandler(UnknownDataType.class, new UnknownDataTypeHandler());
    }

    @Override
    public DataType getType(NativeType nativeType) {
        Class<? extends DataType> dataTypeClass = this.nativeTypeMapping.get(nativeType.getName());
        if (dataTypeClass == null && (dataTypeClass = this.sqlTypeMapping.get(nativeType.getSqlType())) == null) {
            dataTypeClass = UnknownDataType.class;
        }
        DataTypeHandler handler = this.getTypeHandler(dataTypeClass);
        return handler.create(nativeType);
    }

    @Override
    public DataTypeHandler getTypeHandler(DataType dataType) {
        Assert.notNull((Object)dataType, (String)"[Assertion failed] - this argument is required; it must not be null");
        return this.getTypeHandler(dataType.getClass());
    }

    protected DataTypeHandler getTypeHandler(Class<?> dataTypeClass) {
        DataTypeHandler handler = this.typeHandlers.get(dataTypeClass);
        if (handler == null) {
            throw new IllegalStateException("There is not matching type handler registered for given type (" + dataTypeClass.getName() + ")");
        }
        return handler;
    }

    protected void mapType(int jdbcType, Class<? extends DataType> dataTypeClass) {
        Assert.notNull(dataTypeClass, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (!this.typeHandlers.containsKey(dataTypeClass)) {
            throw new IllegalStateException("There is not matching type handler registered for " + dataTypeClass.getName());
        }
        this.sqlTypeMapping.put(jdbcType, dataTypeClass);
    }

    protected void mapNativeType(String nativeTypeName, Class<? extends DataType> dataTypeClass) {
        Assert.hasText((String)nativeTypeName, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.notNull(dataTypeClass, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (!this.typeHandlers.containsKey(dataTypeClass)) {
            throw new IllegalStateException("There is not matching type handler registered for " + dataTypeClass.getName());
        }
        this.nativeTypeMapping.put(nativeTypeName, dataTypeClass);
    }

    protected void registerTypeHandler(Class<? extends DataType> dataTypeClass, DataTypeHandler typeHandler) {
        Assert.notNull(dataTypeClass, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)typeHandler, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.typeHandlers.put(dataTypeClass, typeHandler);
    }
}

