/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.type;

import com.suncode.dbexplorer.database.internal.type.HibernateDataTypeHandler;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.DateTimeDataType;
import com.suncode.dbexplorer.database.type.NativeType;
import com.suncode.dbexplorer.util.convert.LocalDateTimeToDateConverter;
import com.suncode.dbexplorer.util.convert.LocalDateToDateConverter;
import com.suncode.dbexplorer.util.convert.StringToDateConverter;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class DateTimeDataTypeHandler
extends HibernateDataTypeHandler {
    @Override
    public DataType create(NativeType nativeType) {
        return new DateTimeDataType(nativeType);
    }

    @Override
    protected Object convert(Object value, Class<?> targetClass, DataType dataType) {
        if (value instanceof String) {
            StringToDateConverter c = new StringToDateConverter();
            return c.convert((String)value);
        }
        if (value instanceof LocalDate) {
            LocalDateToDateConverter c = new LocalDateToDateConverter();
            return c.convert((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTimeToDateConverter c = new LocalDateTimeToDateConverter();
            return c.convert((LocalDateTime)value);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected Type resolveHibernateType(DataType dataType) {
        return StandardBasicTypes.TIMESTAMP;
    }
}

