/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.support;

import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.ConnectionUrlResolver;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.internal.schema.SchemaLoader;
import com.suncode.dbexplorer.database.internal.type.DataTypeRegistry;
import com.suncode.dbexplorer.database.schema.DatabaseSchema;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractDatabaseImplementor
implements DatabaseImplementor {
    private final DatabaseType implementedType;
    private final SchemaLoader schemaLoader;
    private final DataTypeRegistry typeRegistry;
    private final ConnectionUrlResolver urlResolver;

    public AbstractDatabaseImplementor(DatabaseType databaseType, SchemaLoader schemaLoader, ConnectionUrlResolver urlResolver, DataTypeRegistry typeRegistry) {
        Assert.notNull((Object)((Object)databaseType), (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)schemaLoader, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)urlResolver, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)typeRegistry, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.implementedType = databaseType;
        this.schemaLoader = schemaLoader;
        this.urlResolver = urlResolver;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public Class<? extends Driver> getDriverClass() {
        try {
            Class<?> driverClass = Class.forName(this.getDriverClassName(), true, ClassUtils.getDefaultClassLoader());
            if (!Driver.class.isAssignableFrom(driverClass)) {
                throw new ClassNotFoundException(this.getDriverClassName());
            }
            return driverClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getDriverClassName();

    @Override
    public boolean handles(DatabaseType type) {
        return this.implementedType == type;
    }

    @Override
    public DataTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public String buildConnectionUrl(ConnectionString connectionString) {
        if (StringUtils.isNotEmpty((String)connectionString.getJdbcUrl())) {
            return connectionString.getJdbcUrl();
        }
        return this.urlResolver.resolve(connectionString);
    }

    @Override
    public String getCatalog(DatabaseSession session) {
        try {
            return session.getConnection().getCatalog();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<DatabaseSchema> readSchemas(DatabaseSession session, List<String> schemasNames) {
        try {
            return this.schemaLoader.loadSchemas(session, schemasNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading schemas", e);
        }
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escapeString(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        String[] splited = tableName.split("\\.");
        if (splited.length == 1) {
            return this.escapeString(splited[0]);
        }
        return this.escapeString(splited[0]) + "." + this.escapeString(splited[1]);
    }

    protected String escapeString(String value) {
        return "\"" + value + "\"";
    }
}

