/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query.support;

import com.suncode.dbexplorer.database.internal.query.CreateQueryImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BuildSqlQuery {
    protected String tableName;
    protected List<CreateQueryImpl.Column> columns;
    protected Set<Integer> primaryKeyIndexes;
    protected Map<String, String[]> foreignKeys;

    public abstract String buildSql();

    protected String getSqlForForeignKeys() {
        StringBuilder sql = new StringBuilder();
        if (!this.foreignKeys.isEmpty()) {
            Iterator<String[]> iterator = this.foreignKeys.values().iterator();
            while (iterator.hasNext()) {
                String[] foreignkeyData;
                String[] foreignKey = foreignkeyData = iterator.next();
                sql.append(", CONSTRAINT fk_" + foreignKey[1]);
                sql.append(" FOREIGN KEY (" + foreignKey[0] + ")");
                sql.append(" REFERENCES " + foreignKey[1] + "(" + foreignKey[2] + ") ");
            }
        }
        return sql.toString();
    }

    protected String getSqlForPrimaryKeys() {
        StringBuilder sql = new StringBuilder();
        if (!this.primaryKeyIndexes.isEmpty()) {
            sql.append(", CONSTRAINT " + this.tableName + "_pk PRIMARY KEY(");
            for (Integer primaryId : this.primaryKeyIndexes) {
                sql.append(this.columns.get(primaryId).getName() + ", ");
            }
            sql.delete(sql.length() - 2, sql.length());
            sql.append(") ");
        }
        return sql.toString();
    }

    public BuildSqlQuery(String tableName, List<CreateQueryImpl.Column> columns, Set<Integer> primaryKeyIndexes, Map<String, String[]> foreignKeys) {
        this.tableName = tableName;
        this.columns = columns;
        this.primaryKeyIndexes = primaryKeyIndexes;
        this.foreignKeys = foreignKeys;
    }
}

