/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query.support;

import com.suncode.dbexplorer.database.internal.query.CreateQueryImpl;
import com.suncode.dbexplorer.database.internal.query.support.BuildSqlQuery;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildCreateQueryOracle
extends BuildSqlQuery {
    public BuildCreateQueryOracle(String tableName, List<CreateQueryImpl.Column> columns, Set<Integer> primaryKeyIndexes, Map<String, String[]> foreignKeys) {
        super(tableName, columns, primaryKeyIndexes, foreignKeys);
    }

    @Override
    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        for (CreateQueryImpl.Column column : this.columns) {
            sql.append(column.getName() + " " + column.getType() + " ");
            sql.append(column.isNullable() ? ", " : "NOT NULL, ");
            if (!column.isAutoincrement()) continue;
            throw new RuntimeException("Cannot apply autoincrement in Oracle databases.");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(this.getSqlForPrimaryKeys());
        sql.append(this.getSqlForForeignKeys());
        sql.append(")");
        return sql.toString();
    }
}

