/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.query;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.RecordId;
import com.suncode.dbexplorer.database.internal.DatabaseImplementor;
import com.suncode.dbexplorer.database.internal.query.AbstractQuery;
import com.suncode.dbexplorer.database.internal.query.QueryContextImpl;
import com.suncode.dbexplorer.database.internal.type.DataTypeHandler;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.Order;
import com.suncode.dbexplorer.database.query.Page;
import com.suncode.dbexplorer.database.query.Pagination;
import com.suncode.dbexplorer.database.query.QueryContext;
import com.suncode.dbexplorer.database.query.QueryParameter;
import com.suncode.dbexplorer.database.query.SelectQuery;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.type.BasicDataType;
import com.suncode.dbexplorer.database.type.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ibatis.jdbc.SQL;
import org.hibernate.SQLQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.util.Assert;

public class SelectQueryImpl
extends AbstractQuery
implements SelectQuery {
    private List<Condition> whereConditions = new ArrayList<Condition>();
    private List<Order> orders = new ArrayList<Order>();
    private boolean includeBinary;
    private int counter = 0;
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, String> aliases2 = new HashMap<String, String>();

    public SelectQueryImpl(DatabaseSession session, DatabaseImplementor implementor) {
        super(session, implementor);
    }

    @Override
    public SelectQuery from(String table) {
        Assert.hasText((String)table, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        AbstractQuery.TablePathInfo pathInfo = this.getPathInfo(table);
        return this.from(pathInfo.getSchema(), pathInfo.getName());
    }

    @Override
    public SelectQuery from(String schema, String table) {
        Assert.hasText((String)schema, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)table, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.rootTable = this.session.getDatabase().getSchema(schema).getTable(table);
        return this;
    }

    @Override
    public SelectQuery where(Condition ... conditions) {
        for (Condition condition : conditions) {
            this.where(condition);
        }
        return this;
    }

    @Override
    public SelectQuery where(Condition condition) {
        Assert.notNull((Object)condition, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.whereConditions.add(condition);
        return this;
    }

    @Override
    public SelectQuery addOrder(Order order) {
        return this.addOrder(new Order[]{order});
    }

    @Override
    public SelectQuery addOrder(Order ... orders) {
        for (Order order : orders) {
            Assert.notNull((Object)order, (String)"[Assertion failed] - this argument is required; it must not be null");
            this.orders.add(order);
        }
        return this;
    }

    @Override
    public SelectQuery includeBinary() {
        this.includeBinary = true;
        return this;
    }

    @Override
    public Record uniqueRecord() {
        List<Record> records = this.list();
        if (records.size() > 1) {
            throw new IllegalStateException("Non unique result set: found " + records.size() + " matching records");
        }
        return records.isEmpty() ? null : records.get(0);
    }

    @Override
    public long count() {
        SQLQuery count = this.prepareSqlQuery(true);
        return (Long)count.uniqueResult();
    }

    @Override
    public List<Record> list() {
        SQLQuery query = this.prepareSqlQuery(false);
        return query.list();
    }

    @Override
    public Page<Record> page(Pagination pagination) {
        Assert.notNull((Object)pagination, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (!pagination.hasOrder()) {
            String column = this.rootTable.hasPrimaryKey() ? this.rootTable.getPrimaryKeyColumns()[0].getName() : this.rootTable.getColumns().get(0).getName();
            pagination.addOrder(Order.ASC(column));
        }
        this.orders.addAll(0, pagination.getOrder());
        SQLQuery query = this.prepareSqlQuery(false);
        query.setFirstResult(pagination.getStart());
        query.setMaxResults(pagination.getLimit());
        List records = query.list();
        long size = records.size();
        if (size == (long)pagination.getLimit() || pagination.getStart() != 0) {
            SQLQuery count = this.prepareSqlQuery(true);
            size = (Long)count.uniqueResult();
        }
        return new Page<Record>(records, size);
    }

    private SQLQuery prepareSqlQuery(boolean count) {
        DataTypeHandler typeHandler;
        DataType type;
        QueryContextImpl queryContext = new QueryContextImpl(this.rootTable, this.implementor);
        SQL rawSql = this.buildSql(count, queryContext);
        StringBuilder sql = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(rawSql.toString().replace("\n", " "), " \"=><()", true);
        ArrayList parameters = Lists.newArrayList();
        for (Condition condition : this.whereConditions) {
            Collections.addAll(parameters, condition.getParameters(queryContext));
        }
        int paramCount = 0;
        ArrayList binded = Lists.newArrayList();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("?")) {
                QueryParameter param = (QueryParameter)parameters.get(paramCount);
                String paramName = "param" + paramCount;
                ++paramCount;
                binded.add(new BindParam(paramName, param));
                sql.append(":" + paramName);
                continue;
            }
            sql.append(token);
        }
        NativeQuery sqlQuery = this.session.hibernateSession().createSQLQuery(sql.toString());
        if (!count) {
            sqlQuery.setResultTransformer((ResultTransformer)new RecordResultTransformer());
        }
        for (BindParam param : binded) {
            type = param.parameter.getType();
            typeHandler = this.implementor.getTypeRegistry().getTypeHandler(type);
            typeHandler.bindParameter(type, param.name, param.parameter.getValue(), (SQLQuery)sqlQuery);
        }
        if (count) {
            sqlQuery.addScalar("count", (Type)StandardBasicTypes.LONG);
        } else {
            for (ColumnSchema column : this.rootTable.getColumns()) {
                type = column.getType();
                typeHandler = this.implementor.getTypeRegistry().getTypeHandler(type);
                typeHandler.setScalar(type, this.aliases.get(column.getName()), (SQLQuery)sqlQuery);
            }
        }
        return sqlQuery;
    }

    private SQL buildSql(boolean count, QueryContext queryContext) {
        SQL sql = new SQL();
        if (count) {
            sql.SELECT("count(1) as " + this.implementor.escapeColumnName("count"));
        } else {
            for (String column : this.rootTable.getColumnNames()) {
                ColumnSchema col = this.rootTable.getColumn(column);
                if (BasicDataType.is(col.getType(), BasicDataType.BINARY) && !this.includeBinary) continue;
                String alias = column.replaceAll("[^\\w]", "_") + this.counter++;
                this.aliases.put(column, alias);
                this.aliases2.put(alias, column);
                sql.SELECT(this.implementor.escapeColumnName(column) + " as " + alias);
            }
        }
        sql.FROM(this.implementor.escapeTableName(this.rootTable.getFullName()));
        for (Condition condition : this.whereConditions) {
            String conditionSql = condition.toSql(queryContext);
            sql.WHERE(conditionSql);
        }
        if (!count) {
            for (Order order : this.orders) {
                sql.ORDER_BY(this.implementor.escapeColumnName(order.getColumn()) + " " + String.valueOf((Object)order.getOrderType()));
            }
        }
        return sql;
    }

    private static class BindParam {
        String name;
        QueryParameter parameter;

        public BindParam(String name, QueryParameter parameter) {
            this.name = name;
            this.parameter = parameter;
        }
    }

    private class RecordResultTransformer
    implements ResultTransformer {
        private RecordResultTransformer() {
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            Record record = SelectQueryImpl.this.session.createRecord(SelectQueryImpl.this.rootTable.getSchema(), SelectQueryImpl.this.rootTable.getName());
            for (int i = 0; i < aliases.length; ++i) {
                record.set(SelectQueryImpl.this.aliases2.get(aliases[i]), tuple[i]);
            }
            if (record.hasId()) {
                RecordId id = record.getId();
                record.setId(id);
            }
            return record;
        }

        public List transformList(List collection) {
            return collection;
        }
    }
}

