/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.oracle;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.internal.oracle.OracleDataTypeRegistry;
import com.suncode.dbexplorer.database.internal.schema.jdbc.ColumnData;
import com.suncode.dbexplorer.database.internal.schema.jdbc.JdbcSchemaLoader;
import com.suncode.dbexplorer.database.internal.schema.jdbc.PrimaryKeyData;
import com.suncode.dbexplorer.database.internal.support.ResultSetMapper;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.Sequence;
import com.suncode.dbexplorer.database.type.DataType;
import com.suncode.dbexplorer.database.type.NativeType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OracleSchemaLoader
extends JdbcSchemaLoader {
    private static final Logger log = LoggerFactory.getLogger(OracleSchemaLoader.class);
    private final OracleDataTypeRegistry dataTypeRegistry;

    @Autowired
    public OracleSchemaLoader(OracleDataTypeRegistry dataTypeRegistry) {
        super(dataTypeRegistry);
        this.dataTypeRegistry = dataTypeRegistry;
    }

    @Override
    protected List<Sequence> readSequences(DatabaseSession session, String schemaName) {
        List results = session.hibernateSession().createSQLQuery("SELECT SEQUENCE_NAME as seqname FROM ALL_SEQUENCES").addScalar("seqname", (Type)StandardBasicTypes.STRING).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        LinkedList<Sequence> sequences = new LinkedList<Sequence>();
        for (Map row : results) {
            String sequenceName = (String)row.get("seqname");
            sequences.add(new Sequence(sequenceName));
        }
        return sequences;
    }

    @Override
    protected List<ColumnSchema> readColumns(String tableName, String catalog, String schema, DatabaseMetaData metaData) throws SQLException {
        List<ColumnData> columnsData = ResultSetMapper.map(metaData.getColumns(catalog, schema, tableName, null)).mapString("COLUMN_NAME", "name").mapInt("DATA_TYPE", "jdbcType").mapString("TYPE_NAME", "typeName").mapInt("COLUMN_SIZE", "size").mapYesNoBoolean("IS_NULLABLE", "nullable").mapInt("ORDINAL_POSITION", "position").beans(ColumnData.class);
        List<ColumnData> uniqueColumns = ResultSetMapper.map(metaData.getIndexInfo(catalog, schema, "\"" + tableName + "\"", true, true)).mapString("COLUMN_NAME", "name").beans(ColumnData.class);
        LinkedList<ColumnSchema> columns = new LinkedList<ColumnSchema>();
        for (ColumnData columnData : columnsData) {
            String name = columnData.getTypeName();
            int sqlType = columnData.getJdbcType();
            int length = columnData.getSize();
            NativeType nativeType = new NativeType(name, sqlType, length);
            DataType dataType = this.dataTypeRegistry.getType(nativeType);
            boolean unique = uniqueColumns.stream().filter(c -> c.getName() != null).anyMatch(c -> c.getName().equals(name));
            ColumnSchema column = new ColumnSchema(columnData.getName(), dataType, (Boolean)columnData.getNullable().or((Object)true), false, unique);
            columns.add(column);
        }
        return columns;
    }

    @Override
    protected List<PrimaryKeyData> getUniqueIndicesData(String catalog, String tableName, String schema, DatabaseMetaData metaData) {
        try {
            return ResultSetMapper.map(metaData.getIndexInfo(catalog, null, tableName, true, true)).mapString("INDEX_NAME", "name").mapString("COLUMN_NAME", "columnName").beans(PrimaryKeyData.class).stream().filter(primaryKeyData -> primaryKeyData.getName() != null).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.info("Exception occurred while fetching indexes. Schema: {}, tableName: {}, message: {}", new Object[]{schema, tableName, e.getMessage()});
            return Collections.emptyList();
        }
    }
}

