/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal.oracle;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.internal.oracle.OracleConnectionUrlResolver;
import com.suncode.dbexplorer.database.internal.oracle.OracleDataTypeRegistry;
import com.suncode.dbexplorer.database.internal.oracle.OracleSchemaLoader;
import com.suncode.dbexplorer.database.internal.support.AbstractDatabaseImplementor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OracleDatabase
extends AbstractDatabaseImplementor {
    private static final Logger log = LoggerFactory.getLogger(OracleDatabase.class);

    @Autowired
    public OracleDatabase(OracleSchemaLoader schemaLoader, OracleConnectionUrlResolver urlResolver, OracleDataTypeRegistry typeRegistry) {
        super(DatabaseType.ORACLE, schemaLoader, urlResolver, typeRegistry);
    }

    @Override
    protected String getDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String getCurrentSchemaName(DatabaseSession session) {
        return (String)session.hibernateSession().createSQLQuery("select sys_context( 'userenv', 'current_schema' ) as schema from dual").addScalar("schema", (Type)StandardBasicTypes.STRING).uniqueResult();
    }

    @Override
    public List<String> getSchemasNames(DatabaseSession session) {
        List<String> result = this.getSchemaNamesFromDbaUsers(session);
        if (result.isEmpty()) {
            log.debug("User have no access to DBA views. Searching schemas in user's tablespace");
            result = this.getSchemaNamesFromAllTables(session);
            if (result.isEmpty()) {
                log.debug("Could not find any schemas. Returning deafult schema name");
                return Arrays.asList(session.getDatabase().getDefaultSchemaName());
            }
        }
        return result;
    }

    private List<String> getSchemaNamesFromDbaUsers(DatabaseSession session) {
        try {
            return session.hibernateSession().createSQLQuery("SELECT username as schema FROM dba_users WHERE default_tablespace not in ('SYSTEM','SYSAUX')").addScalar("schema", (Type)StandardBasicTypes.STRING).list();
        }
        catch (HibernateException he) {
            return new ArrayList<String>();
        }
    }

    private List<String> getSchemaNamesFromAllTables(DatabaseSession session) {
        try {
            return session.hibernateSession().createSQLQuery("SELECT OWNER as schema FROM sys.all_tables WHERE tablespace_name NOT IN ('SYSTEM','SYSAUX') GROUP BY OWNER UNION SELECT GRANTOR as schema FROM USER_TAB_PRIVS GROUP BY GRANTOR").addScalar("schema", (Type)StandardBasicTypes.STRING).list();
        }
        catch (HibernateException he) {
            return new ArrayList<String>();
        }
    }
}

