/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database.internal;

import com.google.common.collect.Lists;
import com.suncode.dbexplorer.alias.data.CreateTable;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.RecordId;
import com.suncode.dbexplorer.database.internal.DatabaseImpl;
import com.suncode.dbexplorer.database.internal.query.CreateQueryImpl;
import com.suncode.dbexplorer.database.internal.query.DeleteQueryImpl;
import com.suncode.dbexplorer.database.internal.query.DropQueryImpl;
import com.suncode.dbexplorer.database.internal.query.InsertQueryImpl;
import com.suncode.dbexplorer.database.internal.query.SelectQueryImpl;
import com.suncode.dbexplorer.database.internal.query.UpdateQueryImpl;
import com.suncode.dbexplorer.database.query.Conditions;
import com.suncode.dbexplorer.database.query.CreateQuery;
import com.suncode.dbexplorer.database.query.DeleteQuery;
import com.suncode.dbexplorer.database.query.DropQuery;
import com.suncode.dbexplorer.database.query.InsertQuery;
import com.suncode.dbexplorer.database.query.SelectQuery;
import com.suncode.dbexplorer.database.query.UpdateQuery;
import com.suncode.dbexplorer.database.schema.TableSchema;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.springframework.util.Assert;

public class DatabaseSessionImpl
implements DatabaseSession {
    private final DatabaseImpl database;
    private final Connection connection;
    private final StatelessSession hibernateSession;
    private final Transaction transaction;

    public DatabaseSessionImpl(Connection connection, DatabaseImpl database) {
        this.database = database;
        this.connection = connection;
        this.hibernateSession = database.getSessionFactory().openStatelessSession(connection);
        this.transaction = this.hibernateSession.beginTransaction();
    }

    @Override
    public Database getDatabase() {
        this.ensureOpen();
        return this.database;
    }

    @Override
    public Connection getConnection() {
        this.ensureOpen();
        return this.connection;
    }

    @Override
    public StatelessSession hibernateSession() {
        this.ensureOpen();
        return this.hibernateSession;
    }

    @Override
    public boolean isActive() {
        return this.transaction.isActive();
    }

    @Override
    public void commit() {
        this.ensureOpen();
        try {
            this.transaction.commit();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Error e) {
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void rollback() {
        this.ensureOpen();
        try {
            this.transaction.rollback();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        finally {
            this.close();
        }
    }

    private void close() {
        try {
            this.hibernateSession.close();
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ensureOpen() {
        Assert.state((boolean)this.isActive(), (String)"Session is closed!");
    }

    @Override
    public Record createRecord(String table) {
        String defaultSchema = this.database.getDefaultSchemaName();
        return this.createRecord(defaultSchema, table);
    }

    @Override
    public Record createRecord(String schema, String table) {
        return new Record(schema, table, this.database);
    }

    @Override
    public Record get(String table, RecordId id) {
        String defaultSchema = this.database.getDefaultSchemaName();
        return this.get(defaultSchema, table, id);
    }

    @Override
    public Record get(String schema, String table, RecordId id) {
        return this.select().from(schema + "." + table).where(Conditions.idEq(id)).uniqueRecord();
    }

    @Override
    public void insert(Record record) {
        ArrayList columns = Lists.newArrayList();
        ArrayList values = Lists.newArrayList();
        for (String column : record.getData().keySet()) {
            columns.add(column);
            values.add(record.get(column));
        }
        this.insert().into(record.getTable().getFullName()).values(columns, values).execute();
    }

    @Override
    public boolean update(Record record) {
        Assert.notNull((Object)record, (String)"[Assertion failed] - this argument is required; it must not be null");
        UpdateQuery update = this.update().table(record.getTable().getFullName());
        boolean modified = false;
        for (String column : record.getData().keySet()) {
            Object value = record.get(column);
            update.set(column, value);
            modified = true;
        }
        if (!modified) {
            return false;
        }
        return update.where(Conditions.idEq(record.getId())).execute() > 0;
    }

    @Override
    public void delete(Record record) {
        Assert.notNull((Object)record, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.delete().from(record.getTable().getFullName()).where(Conditions.idEq(record.getId())).execute();
    }

    @Override
    public void createTable(CreateTable table) {
        Assert.notNull((Object)table, (String)"[Assertion failed] - this argument is required; it must not be null");
        CreateQuery createTableQuery = StringUtils.isBlank((CharSequence)table.getSchema()) ? this.create().table(table.getName()) : this.create().table(table.getSchema(), table.getName());
        Set<CreateTable.ForeignKey> foreignKeys = table.getForeignKeys();
        for (CreateTable.Column column : table.getColumns()) {
            String name = column.getName();
            createTableQuery.column(name, column.getDataType(), column.isNullable(), column.isAutoIncrement());
            if (column.isPrimaryKey()) {
                createTableQuery.setAsPrimary();
            }
            for (CreateTable.ForeignKey fk : foreignKeys) {
                if (!name.equals(fk.getColumnName())) continue;
                createTableQuery.setAsForeign(fk.getForeignTableName(), fk.getForeignColumnName());
            }
        }
        createTableQuery.execute();
    }

    @Override
    public void drop(String table) {
        String defaultSchema = this.database.getDefaultSchemaName();
        this.drop(defaultSchema, table);
    }

    @Override
    public void drop(TableSchema table) {
        Assert.notNull((Object)table, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.drop(table.getSchema(), table.getName());
    }

    @Override
    public void drop(String schema, String table) {
        Assert.hasText((String)table, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)schema, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.drop().table(schema, table).execute();
    }

    @Override
    public SelectQuery select() {
        return new SelectQueryImpl(this, this.database.getImplementor());
    }

    @Override
    public InsertQuery insert() {
        return new InsertQueryImpl(this, this.database.getImplementor());
    }

    @Override
    public UpdateQuery update() {
        return new UpdateQueryImpl(this, this.database.getImplementor());
    }

    @Override
    public DeleteQuery delete() {
        return new DeleteQueryImpl(this, this.database.getImplementor());
    }

    @Override
    public CreateQuery create() {
        return new CreateQueryImpl(this, this.database.getImplementor());
    }

    @Override
    public DropQuery drop() {
        return new DropQueryImpl(this, this.database.getImplementor());
    }
}

