/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.dbexplorer.database;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.RecordId;
import com.suncode.dbexplorer.database.schema.TableSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class Record {
    private final TableSchema table;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private RecordId id;

    public Record(String schema, String table, Database database) {
        Assert.hasText((String)schema, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)table, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.notNull((Object)database, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.table = database.getSchema(schema).getTable(table);
    }

    @JsonIgnore
    public boolean hasId() {
        return this.table.hasPrimaryKey();
    }

    @JsonIgnore
    public RecordId getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.table.hasPrimaryKey()) {
            RecordId.Composite id = RecordId.buildComposite();
            for (String pkCol : this.table.getPrimaryKey().getColumns()) {
                id.add(pkCol, this.get(pkCol));
            }
            return id.get();
        }
        throw new IllegalStateException("Record [" + this.toString() + "] does not have any id in " + this.table.getName() + " table");
    }

    public void setId(RecordId id) {
        this.id = id;
    }

    @JsonIgnore
    public TableSchema getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public void set(String column, Object value) {
        if (!this.table.hasColumn(column)) {
            throw new IllegalStateException("Record [" + this.toString() + "] mapped table does not contain given column [" + column + "]");
        }
        this.data.put(column, value);
    }

    public Object get(String column) {
        return this.data.get(column);
    }

    public Map<String, Object> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    public String toString() {
        return "Record(" + String.valueOf(this.table) + ")";
    }
}

